/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jdom2.Document;
import org.jdom2.Element;
import org.palladiosimulator.retriever.extraction.rules.data.GatewayRoute;
import org.palladiosimulator.retriever.extraction.rules.util.ProjectHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class JaxRSDeploymentRules
implements Rule {
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.jax_rs.deployment";
    public static final String DONE_ID = "org.palladiosimulator.retriever.extraction.rules.jax_rs.deployment.done";
    public static final String XML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";
    public static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";
    public static final String ECMASCRIPT_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript";
    public static final String ECMASCRIPT_ROUTES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.routes";
    public static final String ECMASCRIPT_HOSTNAMES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.hostnames";

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        boolean _not_1;
        boolean _not;
        boolean _hasPartition = blackboard.hasPartition(DONE_ID);
        if (_hasPartition) {
            return;
        }
        Map xmls = blackboard.getDiscoveredFiles(XML_DISCOVERER_ID, Document.class);
        Map<Path, String> hostnames = new HashMap();
        boolean _hasPartition_1 = blackboard.hasPartition(RULE_ID);
        if (_hasPartition_1) {
            Object _partition = blackboard.getPartition(RULE_ID);
            hostnames = (Map)_partition;
        }
        ArrayList<GatewayRoute> routes = new ArrayList<GatewayRoute>();
        Set _entrySet = xmls.entrySet();
        for (Map.Entry xmlEntry : _entrySet) {
            Path xmlPath = (Path)xmlEntry.getKey();
            Document xml = (Document)xmlEntry.getValue();
            boolean _endsWith = xmlPath.endsWith("WEB-INF/web.xml");
            if (!_endsWith) continue;
            Function<Element, String> _function = servlet -> {
                String classTag = servlet.getChildTextTrim("servlet-class", servlet.getNamespace());
                if (classTag != null) {
                    return classTag;
                }
                return servlet.getChildTextTrim("servlet-name", servlet.getNamespace());
            };
            Function<Element, String> _function_1 = servlet -> servlet.getChildTextTrim("servlet-name", servlet.getNamespace());
            Map<String, String> servlets = xml.getRootElement().getChildren("servlet", xml.getRootElement().getNamespace()).stream().collect(Collectors.toMap(_function, _function_1));
            Function<Element, String> _function_2 = servlet -> servlet.getChildTextTrim("servlet-name", servlet.getNamespace());
            Function<Element, String> _function_3 = servlet -> servlet.getChildTextTrim("url-pattern", servlet.getNamespace());
            Map<String, String> servletMappings = xml.getRootElement().getChildren("servlet-mapping", xml.getRootElement().getNamespace()).stream().collect(Collectors.toMap(_function_2, _function_3));
            Collection<String> _values = servlets.values();
            for (String servletName : _values) {
                String _get = servletMappings.get(servletName);
                GatewayRoute _gatewayRoute = new GatewayRoute(_get, servletName, true);
                routes.add(_gatewayRoute);
            }
            HashMap<String, Path> nameToPath = new HashMap<String, Path>();
            Map compilationUnits = blackboard.getDiscoveredFiles(JAVA_DISCOVERER_ID, CompilationUnit.class);
            Set _entrySet_1 = compilationUnits.entrySet();
            for (Map.Entry entry : _entrySet_1) {
                boolean _not2;
                Path compilationUnitPath = (Path)entry.getKey();
                CompilationUnit compilationUnit = (CompilationUnit)entry.getValue();
                List types = compilationUnit.types();
                boolean _isEmpty = types.isEmpty();
                boolean bl = _not2 = !_isEmpty;
                if (!_not2) continue;
                Object _get_1 = types.get(0);
                String name = ((AbstractTypeDeclaration)_get_1).resolveBinding().getQualifiedName();
                nameToPath.put(name, compilationUnitPath);
            }
            Set<Map.Entry<String, String>> _entrySet_2 = servlets.entrySet();
            for (Map.Entry<String, String> servlet2 : _entrySet_2) {
                Path servletPath = (Path)nameToPath.get(servlet2.getKey());
                hostnames.put(servletPath, servlet2.getValue());
            }
        }
        boolean _hasPartition_2 = blackboard.hasPartition(RULE_ID);
        boolean bl = _not = !_hasPartition_2;
        if (_not) {
            blackboard.addPartition(RULE_ID, hostnames);
        }
        Path projectRoot = ProjectHelper.findProjectRoot(path, "pom.xml", "build.gradle");
        boolean _hasPartition_3 = blackboard.hasPartition(ECMASCRIPT_ROUTES_ID);
        if (_hasPartition_3) {
            Object _partition_1 = blackboard.getPartition(ECMASCRIPT_ROUTES_ID);
            Map ecmaScriptRouteMap = (Map)_partition_1;
            boolean _containsKey = ecmaScriptRouteMap.containsKey(projectRoot);
            if (_containsKey) {
                ((List)ecmaScriptRouteMap.get(projectRoot)).addAll(routes);
            } else {
                ecmaScriptRouteMap.put(projectRoot, routes);
            }
        } else {
            HashMap<Path, ArrayList<GatewayRoute>> routeMap = new HashMap<Path, ArrayList<GatewayRoute>>();
            routeMap.put(projectRoot, routes);
            blackboard.addPartition(ECMASCRIPT_ROUTES_ID, routeMap);
        }
        Map<Path, String> hostnameMap = new HashMap<Path, String>();
        boolean _hasPartition_4 = blackboard.hasPartition(ECMASCRIPT_HOSTNAMES_ID);
        if (_hasPartition_4) {
            Object _partition_2 = blackboard.getPartition(ECMASCRIPT_HOSTNAMES_ID);
            hostnameMap = (Map)_partition_2;
        }
        hostnameMap.putAll(hostnames);
        boolean _hasPartition_5 = blackboard.hasPartition(ECMASCRIPT_HOSTNAMES_ID);
        boolean bl2 = _not_1 = !_hasPartition_5;
        if (_not_1) {
            blackboard.addPartition(ECMASCRIPT_HOSTNAMES_ID, hostnameMap);
        }
        blackboard.addPartition(DONE_ID, (Object)true);
    }

    public boolean isBuildRule() {
        return false;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "JAX RS Deployment Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(XML_DISCOVERER_ID, JAVA_DISCOVERER_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of(ECMASCRIPT_RULE_ID);
    }
}

