/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jdom2.Document;
import org.palladiosimulator.retriever.extraction.rules.data.GatewayRoute;
import org.palladiosimulator.retriever.extraction.rules.util.ProjectHelper;
import org.palladiosimulator.retriever.extraction.rules.util.SpringHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class SpringZuulRules
implements Rule {
    private static final Logger LOG = Logger.getLogger(SpringZuulRules.class);
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.spring.zuul";
    public static final String YAML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.yaml";
    public static final String YAML_MAPPERS_KEY = "org.palladiosimulator.retriever.extraction.discoverers.yaml.mappers";
    public static final String XML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";
    public static final String PROPERTIES_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.properties";
    public static final String ECMASCRIPT_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript";
    public static final String ECMASCRIPT_ROUTES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.routes";
    public static final String ECMASCRIPT_HOSTNAMES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.hostnames";

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        Object _partition = blackboard.getPartition(YAML_DISCOVERER_ID);
        Map rawYamls = (Map)_partition;
        Object _partition_1 = blackboard.getPartition(YAML_MAPPERS_KEY);
        Map yamlMappers = (Map)_partition_1;
        Map poms = blackboard.getDiscoveredFiles(XML_DISCOVERER_ID, Document.class);
        Map propertyFiles = blackboard.getDiscoveredFiles(PROPERTIES_DISCOVERER_ID, Properties.class);
        Path projectRoot = ProjectHelper.findProjectRoot(path, "pom.xml");
        Path configRoot = SpringHelper.findConfigRoot(poms);
        if (configRoot == null) {
            return;
        }
        Map<Path, List<GatewayRoute>> routeMap = new HashMap();
        boolean _hasPartition = blackboard.hasPartition(RULE_ID);
        if (_hasPartition) {
            Object _partition_2 = blackboard.getPartition(RULE_ID);
            routeMap = (Map)_partition_2;
        }
        if (projectRoot != null && routeMap.containsKey(projectRoot)) {
            return;
        }
        Function _xifexpression = null;
        _xifexpression = projectRoot == null ? null : (Function)yamlMappers.get(SpringHelper.findFile(yamlMappers.keySet(), projectRoot.resolve("src/main/resources"), Set.of("bootstrap.yaml", "bootstrap.yml")));
        Function bootstrapYaml = _xifexpression;
        Properties _xifexpression_1 = null;
        _xifexpression_1 = projectRoot == null ? null : (Properties)propertyFiles.get(SpringHelper.findFile(propertyFiles.keySet(), projectRoot.resolve("src/main/resources"), Set.of("application.properties")));
        Properties applicationProperties = _xifexpression_1;
        String applicationName = SpringHelper.getFromYamlOrProperties("spring.application.name", bootstrapYaml, applicationProperties);
        Iterable _xifexpression_2 = null;
        _xifexpression_2 = configRoot == null ? null : (Iterable)rawYamls.get(SpringHelper.findFile(rawYamls.keySet(), configRoot.resolve("src/main/resources/shared"), Set.of(String.valueOf(applicationName) + ".yaml", String.valueOf(applicationName) + ".yml")));
        Iterable projectConfigYaml = _xifexpression_2;
        List<GatewayRoute> routes = this.collectRoutes(projectConfigYaml);
        for (GatewayRoute route : routes) {
            String _path = route.getPath();
            String _plus = "Route in " + applicationName + ": " + _path;
            String _plus_1 = String.valueOf(_plus) + " -> ";
            String _targetHost = route.getTargetHost();
            String _plus_2 = String.valueOf(_plus_1) + _targetHost;
            LOG.warn((Object)_plus_2);
        }
        routeMap.put(projectRoot, routes);
        boolean _hasPartition_1 = blackboard.hasPartition(RULE_ID);
        if (_hasPartition_1) {
            Object _partition_3 = blackboard.getPartition(RULE_ID);
            ((Map)_partition_3).putAll(routeMap);
        } else {
            blackboard.addPartition(RULE_ID, routeMap);
        }
        boolean _hasPartition_2 = blackboard.hasPartition(ECMASCRIPT_ROUTES_ID);
        if (_hasPartition_2) {
            Object _partition_4 = blackboard.getPartition(ECMASCRIPT_ROUTES_ID);
            Map ecmaScriptRouteMap = (Map)_partition_4;
            boolean _containsKey = ecmaScriptRouteMap.containsKey(projectRoot);
            if (_containsKey) {
                ((List)ecmaScriptRouteMap.get(projectRoot)).addAll(routes);
            } else {
                ecmaScriptRouteMap.put(projectRoot, routes);
            }
        } else {
            blackboard.addPartition(ECMASCRIPT_ROUTES_ID, routeMap);
        }
        if (applicationName != null) {
            boolean _not;
            Map<Path, String> hostnameMap = new HashMap<Path, String>();
            boolean _hasPartition_3 = blackboard.hasPartition(ECMASCRIPT_HOSTNAMES_ID);
            if (_hasPartition_3) {
                Object _partition_5 = blackboard.getPartition(ECMASCRIPT_HOSTNAMES_ID);
                hostnameMap = (Map)_partition_5;
            }
            hostnameMap.put(projectRoot, applicationName);
            boolean _hasPartition_4 = blackboard.hasPartition(ECMASCRIPT_HOSTNAMES_ID);
            boolean bl = _not = !_hasPartition_4;
            if (_not) {
                blackboard.addPartition(ECMASCRIPT_HOSTNAMES_ID, hostnameMap);
            }
        }
    }

    public List<GatewayRoute> collectRoutes(Iterable<Map<String, Object>> applicationYamlIter) {
        ArrayList<GatewayRoute> result = new ArrayList<GatewayRoute>();
        if (applicationYamlIter == null || IterableExtensions.isEmpty(applicationYamlIter)) {
            return result;
        }
        Map _get = ((Map[])Conversions.unwrapArray(applicationYamlIter, Map.class))[0];
        Map applicationYaml = _get;
        if (applicationYaml == null) {
            return result;
        }
        Object zuulObject = applicationYaml.get("zuul");
        if (!(zuulObject instanceof Map)) {
            return result;
        }
        Map zuul = (Map)zuulObject;
        Object routesObject = zuul.get("routes");
        if (!(routesObject instanceof Map)) {
            return result;
        }
        Map routes = (Map)routesObject;
        Collection _values = routes.values();
        for (Map route : _values) {
            boolean hasUrl;
            Object pathObject = route.get("path");
            Object serviceIdObject = route.get("serviceId");
            Object urlObject = route.get("url");
            Object stripPrefixObject = route.get("stripPrefix");
            if (stripPrefixObject == null || !(stripPrefixObject instanceof Boolean)) {
                stripPrefixObject = true;
            }
            Boolean stripPrefix = (Boolean)stripPrefixObject;
            boolean hasServiceId = serviceIdObject != null && serviceIdObject instanceof String;
            boolean hasPath = pathObject != null && pathObject instanceof String;
            boolean bl = hasUrl = urlObject != null && urlObject instanceof String;
            if (!hasPath || !hasServiceId && !hasUrl) continue;
            String path = (String)pathObject;
            if (hasServiceId) {
                String serviceId = (String)serviceIdObject;
                GatewayRoute _gatewayRoute = new GatewayRoute(path, serviceId, stripPrefix);
                result.add(_gatewayRoute);
                continue;
            }
            if (!hasUrl) continue;
            String url = (String)urlObject;
            String _hostname = this.toHostname(url);
            GatewayRoute _gatewayRoute_1 = new GatewayRoute(path, _hostname, stripPrefix);
            result.add(_gatewayRoute_1);
        }
        return result;
    }

    public String toHostname(String url) {
        int pathIndex;
        int hostnameStart;
        int portIndex;
        int schemaEnd = url.lastIndexOf("://");
        if (schemaEnd == -1) {
            schemaEnd = -3;
        }
        if ((portIndex = url.indexOf(":", hostnameStart = schemaEnd + 3)) == -1) {
            portIndex = url.length();
        }
        if ((pathIndex = url.indexOf("/", hostnameStart)) == -1) {
            pathIndex = url.length();
        }
        int hostnameEnd = Math.min(portIndex, pathIndex);
        return url.substring(hostnameStart, hostnameEnd);
    }

    public boolean isBuildRule() {
        return false;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "Spring Zuul Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(YAML_DISCOVERER_ID, XML_DISCOVERER_ID, PROPERTIES_DISCOVERER_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of(ECMASCRIPT_RULE_ID);
    }
}

