/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.palladiosimulator.retriever.extraction.commonalities.InterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.Name;

public class RESTName
implements InterfaceName {
    private final String host;
    private final List<String> path;

    public RESTName(String host, String path) throws IllegalArgumentException {
        this.host = host;
        Optional<List<String>> parsedPath = RESTName.parsePath(String.valueOf(host) + path);
        if (parsedPath.isEmpty()) {
            throw new IllegalArgumentException("Could not parse path due to illegal format: \"" + path + "\"");
        }
        this.path = parsedPath.get();
        this.path.remove(0);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public List<String> getInterfaces() {
        Stack<List<String>> prefixes = new Stack<List<String>>();
        if (this.path.size() > 0) {
            prefixes.push(List.of(this.path.get(0)));
            int i = 1;
            while (i < this.path.size()) {
                ArrayList<String> prefix = new ArrayList<String>((Collection)prefixes.peek());
                prefix.add(this.path.get(i));
                prefixes.push(prefix);
                ++i;
            }
        }
        ArrayList<String> interfaces = new ArrayList<String>(prefixes.size());
        while (!prefixes.empty()) {
            interfaces.add(this.toName((List)prefixes.pop()));
        }
        interfaces.add(this.toName(List.of()));
        return interfaces;
    }

    @Override
    public InterfaceName createName(String name) {
        return RESTName.parse(name).orElseThrow();
    }

    private String toName(List<String> path) {
        StringBuilder name = new StringBuilder();
        name.append("/");
        int i = 0;
        while (i < path.size()) {
            name.append(path.get(i));
            if (i + 1 < path.size()) {
                name.append("/");
            }
            ++i;
        }
        return String.valueOf(this.host) + name.toString();
    }

    public String toString() {
        return this.toName(this.path);
    }

    private static Optional<List<String>> parsePath(String string) {
        String[] segments = string.split("/");
        if (segments.length == 1 && !string.endsWith("/")) {
            return Optional.empty();
        }
        return Optional.of(List.of(segments).stream().filter(x -> !x.isEmpty()).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(this.host, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RESTName other = (RESTName)obj;
        return Objects.equals(this.host, other.host) && Objects.equals(this.path, other.path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<String> getCommonInterface(Name other) {
        void var3_2;
        RESTName rESTName;
        Name name = other;
        if (name instanceof RESTName && (rESTName = (RESTName)name) == (RESTName)var3_2) {
            void otherREST;
            if (!this.host.equals(otherREST.host)) {
                return Optional.empty();
            }
            int commonSegments = 0;
            while (commonSegments < Math.min(this.path.size(), otherREST.path.size()) && this.path.get(commonSegments).equals(otherREST.path.get(commonSegments))) {
                ++commonSegments;
            }
            if (commonSegments == 0) {
                return Optional.empty();
            }
            String commonPath = this.toName(this.path.subList(0, commonSegments));
            return Optional.of(new RESTName(this.host, commonPath).toString());
        }
        HashSet<String> interfaces = new HashSet<String>(this.getInterfaces());
        for (String iface : other.getInterfaces()) {
            if (!interfaces.contains(iface)) continue;
            return Optional.of(iface);
        }
        return Optional.empty();
    }

    @Override
    public boolean isPartOf(String iface) {
        Optional<RESTName> parsedIface;
        String pathCandidate = iface;
        if (iface.contains("[")) {
            int pathEnd = iface.indexOf(91);
            pathCandidate = iface.substring(0, pathEnd);
        }
        if ((parsedIface = RESTName.parse(pathCandidate)).isEmpty()) {
            return false;
        }
        RESTName restIface = parsedIface.get();
        if (!restIface.host.equals(this.host)) {
            return false;
        }
        if (restIface.path.size() > this.path.size()) {
            return false;
        }
        int i = 0;
        while (i < restIface.path.size()) {
            if (!this.path.get(i).equals(restIface.path.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Optional<RESTName> parse(String iface) {
        if (iface.contains("[")) {
            return Optional.empty();
        }
        Optional<List<String>> interfacePathOption = RESTName.parsePath(iface);
        if (interfacePathOption.isEmpty()) {
            return Optional.empty();
        }
        List<String> path = interfacePathOption.get();
        String host = path.remove(0);
        return Optional.of(new RESTName(host, "/" + String.join((CharSequence)"/", path)));
    }
}

