/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.ComponentBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.CompositeBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.EntireInterface;
import org.palladiosimulator.retriever.extraction.commonalities.InterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.JavaInterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.JavaOperationName;
import org.palladiosimulator.retriever.extraction.commonalities.Operation;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.commonalities.OperationName;
import org.palladiosimulator.retriever.extraction.commonalities.PCMDetectionResult;
import org.palladiosimulator.retriever.extraction.commonalities.ProvisionsBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.RequirementsBuilder;
import org.palladiosimulator.retriever.extraction.engine.NameConverter;

public class PCMDetector {
    private static final Logger LOG = Logger.getLogger(PCMDetector.class);
    private final Map<CompUnitOrName, ComponentBuilder> components = new ConcurrentHashMap<CompUnitOrName, ComponentBuilder>();
    private final Map<String, CompositeBuilder> composites = new ConcurrentHashMap<String, CompositeBuilder>();
    private final ProvisionsBuilder compositeProvisions = new ProvisionsBuilder();
    private final RequirementsBuilder compositeRequirements = new RequirementsBuilder();
    private final Map<CompUnitOrName, List<String>> weakComponents = new ConcurrentHashMap<CompUnitOrName, List<String>>();
    private final Map<CompUnitOrName, String> separatingIdentifiers = new ConcurrentHashMap<CompUnitOrName, String>();
    private final Set<String> blacklist = new HashSet<String>();

    private static String getFullUnitName(CompUnitOrName unit) {
        if (!unit.isUnit()) {
            return unit.name();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Object type : unit.compilationUnit().get().types()) {
            if (!(type instanceof AbstractTypeDeclaration)) continue;
            String fullTypeName = ((AbstractTypeDeclaration)type).getName().getFullyQualifiedName();
            names.add(fullTypeName);
        }
        if (!names.isEmpty()) {
            return (String)names.get(0);
        }
        return null;
    }

    public void detectComponent(CompUnitOrName unit) {
        if (!unit.isUnit()) {
            this.tryAddComponent(unit);
            return;
        }
        for (Object type : unit.compilationUnit().get().types()) {
            if (!(type instanceof TypeDeclaration) || !this.tryAddComponent(unit)) continue;
            ITypeBinding binding = ((TypeDeclaration)type).resolveBinding();
            this.detectProvidedInterfaceWeakly(unit, binding);
        }
    }

    public void detectRequiredInterface(CompUnitOrName unit, InterfaceName interfaceName) {
        this.detectRequiredInterface(unit, interfaceName, false);
    }

    private void detectRequiredInterface(CompUnitOrName unit, InterfaceName interfaceName, boolean compositeRequired) {
        if (!this.tryAddComponent(unit)) {
            return;
        }
        EntireInterface iface = new EntireInterface(interfaceName);
        this.detectRequiredInterface(unit, compositeRequired, false, iface);
    }

    public void detectRequiredInterface(CompUnitOrName unit, FieldDeclaration field) {
        this.detectRequiredInterface(unit, field, false, false);
    }

    public void detectRequiredInterfaceWeakly(CompUnitOrName unit, FieldDeclaration field) {
        this.detectRequiredInterface(unit, field, false, true);
    }

    private void detectRequiredInterface(CompUnitOrName unit, FieldDeclaration field, boolean compositeRequired, boolean detectWeakly) {
        if (!this.tryAddComponent(unit)) {
            return;
        }
        List<OperationInterface> ifaces = field.fragments().stream().map(x -> x.resolveBinding()).filter(x -> x != null).map(x -> x.getType()).map(x -> new EntireInterface((ITypeBinding)x, new JavaInterfaceName(NameConverter.toPCMIdentifier(x)))).collect(Collectors.toList());
        this.detectRequired(unit, compositeRequired, detectWeakly, ifaces);
    }

    public void detectCompositeRequiredInterfaceWeakly(CompUnitOrName unit, MethodInvocation invocation) {
        IMethodBinding method = invocation.resolveMethodBinding();
        if (method == null) {
            return;
        }
        ITypeBinding type = method.getDeclaringClass();
        if (!this.tryAddComponent(unit)) {
            return;
        }
        EntireInterface iface = new EntireInterface(type, new JavaInterfaceName(NameConverter.toPCMIdentifier(type)));
        this.detectRequiredInterface(unit, true, true, iface);
    }

    public void detectRequiredInterface(CompUnitOrName unit, SingleVariableDeclaration parameter) {
        if (!this.tryAddComponent(unit)) {
            return;
        }
        IVariableBinding parameterBinding = parameter.resolveBinding();
        if (parameterBinding == null) {
            LOG.warn((Object)("Unresolved parameter binding " + parameter.getName() + " detected in " + PCMDetector.getFullUnitName(unit) + "!"));
            return;
        }
        ITypeBinding type = parameterBinding.getType();
        EntireInterface iface = new EntireInterface(type, new JavaInterfaceName(NameConverter.toPCMIdentifier(type)));
        this.detectRequiredInterface(unit, false, false, iface);
    }

    private void detectRequiredInterface(CompUnitOrName unit, boolean compositeRequired, boolean detectWeakly, OperationInterface iface) {
        this.detectRequired(unit, compositeRequired, detectWeakly, List.of(iface));
    }

    private void detectRequired(CompUnitOrName unit, boolean compositeRequired, boolean detectWeakly, Collection<OperationInterface> ifaces) {
        for (OperationInterface iface : ifaces) {
            boolean isProvided;
            boolean bl = isProvided = this.compositeProvisions.containsRelated(iface) || this.components.values().stream().anyMatch(component -> component.provisions().containsRelated(iface));
            if (!isProvided && detectWeakly) {
                this.components.get(unit).requirements().addWeakly(iface);
                if (!compositeRequired) continue;
                this.compositeRequirements.addWeakly(iface);
                continue;
            }
            this.components.get(unit).requirements().add(iface);
            this.components.values().stream().forEach(component -> component.provisions().strengthenIfPresent(iface));
            this.compositeProvisions.strengthenIfPresent(iface);
            if (!compositeRequired) continue;
            this.compositeRequirements.add(iface);
        }
    }

    public void detectProvidedInterfaceWeakly(CompUnitOrName unit, ITypeBinding iface) {
        if (iface == null) {
            LOG.warn((Object)("Unresolved type binding detected in " + PCMDetector.getFullUnitName(unit) + "!"));
            return;
        }
        EntireInterface provision = new EntireInterface(iface, new JavaInterfaceName(NameConverter.toPCMIdentifier(iface)));
        this.detectProvidedInterface(unit, provision, false, true);
    }

    public void detectProvidedOperationWeakly(CompUnitOrName unit, IMethodBinding method) {
        if (method == null) {
            LOG.warn((Object)("Unresolved method binding detected in " + PCMDetector.getFullUnitName(unit) + "!"));
            return;
        }
        this.detectProvidedOperation(unit, method.getDeclaringClass(), method, true);
    }

    public void detectProvidedOperationWeakly(CompUnitOrName unit, ITypeBinding declaringIface, IMethodBinding method) {
        this.detectProvidedOperation(unit, declaringIface, method, true);
    }

    private void detectProvidedOperation(CompUnitOrName unit, ITypeBinding declaringIface, IMethodBinding method, boolean detectWeakly) {
        String operationName;
        if (declaringIface == null) {
            LOG.warn((Object)("Unresolved type binding detected in " + PCMDetector.getFullUnitName(unit) + "!"));
            return;
        }
        if (method == null) {
            LOG.warn((Object)("Unresolved method binding detected in " + PCMDetector.getFullUnitName(unit) + "!"));
            operationName = "[unresolved]";
        } else {
            operationName = method.getName();
        }
        this.detectProvidedOperation(unit, method, new JavaOperationName(NameConverter.toPCMIdentifier(declaringIface), operationName), false, detectWeakly);
    }

    public void detectProvidedOperation(CompUnitOrName unit, IMethodBinding method, OperationName name) {
        this.detectProvidedOperation(unit, method, name, false, false);
    }

    private void detectProvidedOperation(CompUnitOrName unit, IMethodBinding method, OperationName name, boolean compositeProvided, boolean detectWeakly) {
        if (!this.tryAddComponent(unit)) {
            return;
        }
        Operation provision = new Operation(method, name);
        this.detectProvidedInterface(unit, provision, compositeProvided, detectWeakly);
    }

    private void detectProvidedInterface(CompUnitOrName unit, OperationInterface iface, boolean compositeProvided, boolean detectWeakly) {
        boolean isRequired;
        boolean bl = isRequired = this.compositeRequirements.containsRelated(iface) || this.components.values().stream().anyMatch(component -> component.requirements().containsRelated(iface));
        if (!isRequired && detectWeakly) {
            this.components.get(unit).provisions().addWeakly(iface);
            if (compositeProvided) {
                this.compositeProvisions.addWeakly(iface);
            }
        } else {
            this.components.get(unit).provisions().add(iface);
            this.components.values().stream().forEach(component -> component.requirements().strengthenIfPresent(iface));
            this.compositeRequirements.strengthenIfPresent(iface);
            if (compositeProvided) {
                this.compositeProvisions.add(iface);
            }
        }
    }

    public void detectSeparatingIdentifier(CompUnitOrName unit, String separatingIdentifier) {
        if (this.components.get(unit) == null) {
            this.separatingIdentifiers.put(unit, separatingIdentifier);
        } else {
            this.components.get(unit).setSeparatingIdentifier(separatingIdentifier);
        }
    }

    public void detectPartOfComposite(CompUnitOrName unit, String compositeName) {
        if (!this.tryAddComponent(unit)) {
            return;
        }
        if (!this.composites.containsKey(compositeName)) {
            this.composites.put(compositeName, new CompositeBuilder(compositeName));
        }
        this.composites.get(compositeName).addPart(this.components.get(unit));
        if (this.separatingIdentifiers.containsKey(unit)) {
            this.components.get(unit).setSeparatingIdentifier(this.separatingIdentifiers.get(unit));
        }
        if (this.weakComponents.containsKey(unit)) {
            for (String weakCompositeName : this.weakComponents.get(unit)) {
                if (!this.composites.containsKey(weakCompositeName)) {
                    this.composites.put(weakCompositeName, new CompositeBuilder(weakCompositeName));
                }
                this.composites.get(weakCompositeName).addPart(this.components.get(unit));
            }
        }
    }

    public void detectPartOfWeakComposite(CompUnitOrName unit, String compositeName) {
        if (!this.weakComponents.containsKey(unit)) {
            this.weakComponents.put(unit, new ArrayList());
        }
        this.weakComponents.get(unit).add(compositeName);
        boolean isPartOfStrongComposite = this.composites.values().stream().anyMatch(x -> x.hasPart(unit));
        if (isPartOfStrongComposite) {
            if (!this.composites.containsKey(compositeName)) {
                this.composites.put(compositeName, new CompositeBuilder(compositeName));
            }
            this.composites.get(compositeName).addPart(this.components.get(unit));
        }
    }

    public void detectCompositeRequiredInterface(CompUnitOrName unit, InterfaceName interfaceName) {
        this.detectRequiredInterface(unit, interfaceName, true);
    }

    public void detectCompositeProvidedOperation(CompUnitOrName unit, IMethodBinding method, OperationName name) {
        this.detectProvidedOperation(unit, method, name, true, false);
    }

    public Set<CompUnitOrName> getCompilationUnits() {
        return this.components.keySet();
    }

    public PCMDetectionResult getResult() {
        return new PCMDetectionResult(this.components, this.composites, this.compositeProvisions, this.compositeRequirements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(142);
        sb.append("[PCMDetector] {\n\tcomponents: {\n");
        this.components.entrySet().forEach(entry -> {
            sb.append("\t\t\"");
            sb.append(entry.getKey());
            sb.append("\" -> {");
            sb.append(entry.getValue());
            sb.append("\t\t}\n");
        });
        return sb.toString();
    }

    public boolean isPartOfComposite(CompUnitOrName name) {
        for (CompositeBuilder composite : this.composites.values()) {
            if (!composite.hasPart(name)) continue;
            return true;
        }
        return false;
    }

    public void addToBlacklist(String string) {
        this.blacklist.add(string);
        LinkedList<CompUnitOrName> toDelete = new LinkedList<CompUnitOrName>();
        for (CompUnitOrName unit : this.components.keySet()) {
            if (!unit.name().equals(string)) continue;
            toDelete.add(unit);
        }
        for (CompUnitOrName unit : toDelete) {
            this.components.remove(unit);
        }
    }

    private boolean tryAddComponent(CompUnitOrName unit) {
        if (this.components.get(unit) != null) {
            return true;
        }
        if (this.blacklist.contains(unit.name())) {
            return false;
        }
        this.components.put(unit, new ComponentBuilder(unit));
        return true;
    }
}

