/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.Component;
import org.palladiosimulator.retriever.extraction.commonalities.ComponentBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.Composite;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.commonalities.Provisions;
import org.palladiosimulator.retriever.extraction.commonalities.Requirements;
import org.palladiosimulator.retriever.extraction.engine.MapMerger;

public class CompositeBuilder {
    private final String name;
    private final Set<ComponentBuilder> explicitParts = new HashSet<ComponentBuilder>();

    public CompositeBuilder(String name) {
        this.name = name;
    }

    public void addPart(ComponentBuilder componentBuilder) {
        this.explicitParts.add(componentBuilder);
    }

    public boolean hasPart(CompUnitOrName identifier) {
        return this.explicitParts.stream().anyMatch(part -> part.identifier().equals(identifier));
    }

    public Collection<ComponentBuilder> getParts() {
        return Set.copyOf(this.explicitParts);
    }

    public Composite construct(Collection<Component> allComponents, Requirements compositeRequirements, Provisions compositeProvisions, Collection<OperationInterface> visibleProvisions) {
        Logger.getLogger(this.getClass()).warn((Object)("Constructing composite component " + this.name));
        LinkedList<OperationInterface> allDependencies = new LinkedList<OperationInterface>();
        for (OperationInterface requirement : compositeRequirements) {
            allDependencies.add(requirement);
        }
        for (OperationInterface provision : compositeProvisions) {
            allDependencies.add(provision);
        }
        Set<Component> parts = this.explicitParts.stream().map(x -> x.create(allDependencies, visibleProvisions)).collect(Collectors.toSet());
        HashSet<Component> remainingComponents = new HashSet<Component>(allComponents);
        remainingComponents.removeAll(parts);
        HashSet<OperationInterface> internalInterfaces = new HashSet<OperationInterface>();
        int previousPartCount = 0;
        int previousInternalInterfaceCount = 0;
        do {
            previousPartCount = parts.size();
            previousInternalInterfaceCount = internalInterfaces.size();
            CompositeBuilder.propagateRequirements(remainingComponents, compositeRequirements, compositeProvisions, parts, internalInterfaces);
            CompositeBuilder.propagateProvisions(remainingComponents, compositeRequirements, compositeProvisions, parts, internalInterfaces);
        } while (parts.size() > previousPartCount && internalInterfaces.size() > previousInternalInterfaceCount);
        ArrayList<OperationInterface> requirements = new ArrayList<OperationInterface>();
        ArrayList provisions = new ArrayList();
        LinkedList<String> partNames = new LinkedList<String>();
        for (Component part : parts) {
            requirements.addAll(part.requirements().get());
            provisions.add(part.provisions().getGrouped());
            partNames.add(part.name());
        }
        HashMap<String, Integer> prefixes = new HashMap<String, Integer>();
        for (String partName : partNames) {
            String prefix = "";
            String[] stringArray = partName.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nameSegment = stringArray[n2];
                if (!prefix.isEmpty()) {
                    prefix = String.valueOf(prefix) + ".";
                }
                prefix = String.valueOf(prefix) + nameSegment;
                prefixes.put(prefix, 1 + prefixes.getOrDefault(prefix, 0));
                ++n2;
            }
        }
        int maxSupport = prefixes.entrySet().stream().max((a, b) -> ((Integer)a.getValue()).compareTo((Integer)b.getValue())).map(x -> (Integer)x.getValue()).orElse(0);
        String chosenPrefix = prefixes.entrySet().stream().filter(x -> ((Integer)x.getValue()).equals(maxSupport)).map(x -> (String)x.getKey()).max(Comparator.comparing(x -> x.length())).orElse(this.name);
        Logger.getLogger(this.getClass()).warn((Object)("Chose name " + chosenPrefix + " supported by " + maxSupport + "/" + parts.size() + " parts."));
        Set<OperationInterface> externalRequirements = requirements.stream().filter(x -> compositeRequirements.containsEntire((OperationInterface)x) || compositeProvisions.containsEntire((OperationInterface)x)).collect(Collectors.toSet());
        Set<OperationInterface> externalProvisions = MapMerger.merge(provisions).entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(operation -> compositeRequirements.containsEntire((OperationInterface)operation) || compositeProvisions.containsEntire((OperationInterface)operation))).map(entry -> (OperationInterface)entry.getKey()).collect(Collectors.toSet());
        return new Composite(chosenPrefix, parts, externalRequirements, externalProvisions, internalInterfaces);
    }

    private static void propagateProvisions(Set<Component> remainingComponents, Requirements compositeRequirements, Provisions compositeProvisions, Set<Component> parts, Set<OperationInterface> internalInterfaces) {
        LinkedList<Component> newParts = new LinkedList<Component>();
        for (Component providingPart : parts) {
            List<OperationInterface> traversedInterfaces = CompositeBuilder.findRequiringComponents(remainingComponents, compositeRequirements, compositeProvisions, newParts, providingPart);
            PriorityQueue<OperationInterface> sortedInterfaces = new PriorityQueue<OperationInterface>(traversedInterfaces);
            while (!sortedInterfaces.isEmpty()) {
                OperationInterface iface = (OperationInterface)sortedInterfaces.poll();
                boolean isRoot = true;
                for (OperationInterface rootInterface : internalInterfaces) {
                    if (iface.isPartOf(rootInterface)) {
                        isRoot = false;
                        break;
                    }
                    if (!rootInterface.isPartOf(iface)) continue;
                    internalInterfaces.remove(rootInterface);
                    break;
                }
                if (!isRoot) continue;
                internalInterfaces.add(iface);
            }
        }
        parts.addAll(newParts);
    }

    private static void propagateRequirements(Set<Component> remainingComponents, Requirements compositeRequirements, Provisions compositeProvisions, Set<Component> parts, Set<OperationInterface> internalInterfaces) {
        LinkedList<Component> newParts = new LinkedList<Component>();
        for (Component requiringPart : parts) {
            List<OperationInterface> traversedInterfaces = CompositeBuilder.findProvidingComponents(remainingComponents, compositeRequirements, compositeProvisions, newParts, requiringPart);
            PriorityQueue<OperationInterface> sortedInterfaces = new PriorityQueue<OperationInterface>(traversedInterfaces);
            while (!sortedInterfaces.isEmpty()) {
                OperationInterface iface = (OperationInterface)sortedInterfaces.poll();
                boolean isRoot = true;
                for (OperationInterface rootInterface : internalInterfaces) {
                    if (iface.isPartOf(rootInterface)) {
                        isRoot = false;
                        break;
                    }
                    if (!rootInterface.isPartOf(iface)) continue;
                    internalInterfaces.remove(rootInterface);
                    break;
                }
                if (!isRoot) continue;
                internalInterfaces.add(iface);
            }
        }
        parts.addAll(newParts);
    }

    private static List<OperationInterface> findRequiringComponents(Set<Component> remainingComponents, Requirements compositeRequirements, Provisions compositeProvisions, List<Component> newParts, Component providingComponent) {
        Stack provisions = new Stack();
        providingComponent.provisions().get().stream().filter(x -> !compositeRequirements.containsEntire((OperationInterface)x)).filter(x -> !compositeProvisions.containsEntire((OperationInterface)x)).forEach(provisions::add);
        Optional<String> separatingIdentifier = providingComponent.separatingIdentifier();
        ArrayList<OperationInterface> traversedOperations = new ArrayList<OperationInterface>();
        while (!provisions.isEmpty()) {
            OperationInterface provision = (OperationInterface)provisions.pop();
            Set requiringComponents = remainingComponents.stream().filter(x -> x.requirements().containsPartOf(provision)).filter(x -> !providingComponent.equals(x)).filter(x -> x.separatingIdentifier().isEmpty() || separatingIdentifier.isEmpty() || x.separatingIdentifier().equals(separatingIdentifier)).collect(Collectors.toSet());
            if (requiringComponents.isEmpty()) continue;
            traversedOperations.add(provision);
            remainingComponents.removeAll(requiringComponents);
            newParts.addAll(requiringComponents);
        }
        return traversedOperations;
    }

    private static List<OperationInterface> findProvidingComponents(Set<Component> remainingComponents, Requirements compositeRequirements, Provisions compositeProvisions, List<Component> newParts, Component requiringComponent) {
        Stack requirements = new Stack();
        requiringComponent.requirements().get().stream().filter(x -> !compositeRequirements.containsEntire((OperationInterface)x)).filter(x -> !compositeProvisions.containsEntire((OperationInterface)x)).forEach(requirements::add);
        Optional<String> separatingIdentifier = requiringComponent.separatingIdentifier();
        ArrayList<OperationInterface> traversedOperations = new ArrayList<OperationInterface>();
        while (!requirements.isEmpty()) {
            OperationInterface requirement = (OperationInterface)requirements.pop();
            Set providingComponents = remainingComponents.stream().filter(x -> x.provisions().containsPartOf(requirement)).filter(x -> !requiringComponent.equals(x)).filter(x -> x.separatingIdentifier().isEmpty() || separatingIdentifier.isEmpty() || x.separatingIdentifier().equals(separatingIdentifier)).collect(Collectors.toSet());
            if (providingComponents.isEmpty()) continue;
            traversedOperations.add(requirement);
            remainingComponents.removeAll(providingComponents);
            newParts.addAll(providingComponents);
        }
        return traversedOperations;
    }

    public int hashCode() {
        return Objects.hash(this.explicitParts, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeBuilder other = (CompositeBuilder)obj;
        return Objects.equals(this.explicitParts, other.explicitParts) && Objects.equals(this.name, other.name);
    }
}

