/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.palladiosimulator.retriever.extraction.commonalities.InterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.JavaInterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.OperationName;

public class JavaOperationName
implements OperationName {
    private final String iface;
    private final String method;

    public JavaOperationName(String iface, String method) {
        this.iface = iface;
        this.method = method;
    }

    @Override
    public Optional<String> forInterface(String baseInterface) {
        if (!this.iface.equals(baseInterface) && !baseInterface.startsWith(String.valueOf(this.iface) + "#")) {
            return Optional.empty();
        }
        return Optional.of(this.method);
    }

    @Override
    public List<String> getInterfaces() {
        return List.of(this.toString(), this.iface);
    }

    @Override
    public String getInterface() {
        return this.iface;
    }

    @Override
    public InterfaceName createName(String name) {
        return new JavaInterfaceName(name);
    }

    public int hashCode() {
        return Objects.hash(this.iface, this.method);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaOperationName other = (JavaOperationName)obj;
        return Objects.equals(this.iface, other.iface) && Objects.equals(this.method, other.method);
    }

    public String toString() {
        return String.valueOf(this.iface) + "#" + this.method;
    }
}

