/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.commonalities.Provisions;

public class ProvisionsBuilder {
    private final List<OperationInterface> provisions = new LinkedList<OperationInterface>();
    private final Set<OperationInterface> weakProvisions = new HashSet<OperationInterface>();

    public void add(OperationInterface ... provisions) {
        this.add(List.of(provisions));
    }

    public synchronized void add(Collection<OperationInterface> provisions) {
        this.provisions.addAll(provisions);
    }

    public synchronized void addWeakly(OperationInterface iface) {
        this.weakProvisions.add(iface);
    }

    public synchronized void strengthenIfPresent(OperationInterface iface) {
        LinkedList<OperationInterface> remainingProvisions = new LinkedList<OperationInterface>();
        for (OperationInterface provision : this.weakProvisions) {
            boolean partlyProvided = provision.isPartOf(iface);
            boolean entirelyProvided = iface.isPartOf(provision);
            if (partlyProvided || entirelyProvided) {
                this.provisions.add(provision);
                continue;
            }
            remainingProvisions.add(provision);
        }
        this.weakProvisions.clear();
        this.weakProvisions.addAll(remainingProvisions);
    }

    public synchronized boolean containsRelated(OperationInterface requirement) {
        boolean entirelyProvided;
        boolean partlyProvided;
        for (OperationInterface provision : this.provisions) {
            partlyProvided = provision.isPartOf(requirement);
            entirelyProvided = requirement.isPartOf(provision);
            if (!partlyProvided && !entirelyProvided) continue;
            return true;
        }
        for (OperationInterface provision : this.weakProvisions) {
            partlyProvided = provision.isPartOf(requirement);
            entirelyProvided = requirement.isPartOf(provision);
            if (!partlyProvided && !entirelyProvided) continue;
            return true;
        }
        return false;
    }

    public Provisions create(Collection<OperationInterface> allDependencies) {
        return new Provisions(this.provisions, allDependencies);
    }

    public List<OperationInterface> toList() {
        return Collections.unmodifiableList(this.provisions);
    }

    public int hashCode() {
        return Objects.hash(this.provisions, this.weakProvisions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionsBuilder other = (ProvisionsBuilder)obj;
        return Objects.equals(this.provisions, other.provisions) && Objects.equals(this.weakProvisions, other.weakProvisions);
    }
}

