/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class RuleHelper {
    private static final Logger LOG = Logger.getLogger(RuleHelper.class);

    public static String getUnitName(CompilationUnit unit) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        String name = "NO NAME";
        for (AbstractTypeDeclaration abstType : types) {
            name = abstType.getName().getFullyQualifiedName();
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAbstraction(CompilationUnit unit) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        if (RuleHelper.isClassModifiedExactlyWith(unit, "abstract")) {
            return true;
        }
        for (AbstractTypeDeclaration abstType : types) {
            void typeDecl;
            TypeDeclaration typeDeclaration;
            AbstractTypeDeclaration abstractTypeDeclaration = abstType;
            if (!(abstractTypeDeclaration instanceof TypeDeclaration) || (typeDeclaration = (TypeDeclaration)abstractTypeDeclaration) != (TypeDeclaration)abstractTypeDeclaration || !typeDecl.isInterface()) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnitAnnotatedWithName(CompilationUnit unit, String ... names) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            for (AbstractTypeDeclaration abstType : types) {
                if (!RuleHelper.isClassifierAnnotatedWithName((BodyDeclaration)abstType, name)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isObjectAnnotatedWithName(BodyDeclaration body, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(body.modifiers(), IExtendedModifier.class), name);
    }

    public static boolean isObjectAnnotatedWithName(SingleVariableDeclaration parameter, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(parameter.modifiers(), IExtendedModifier.class), name);
    }

    public static boolean isObjectAnnotatedWithName(TypeParameter parameter, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(parameter.modifiers(), IExtendedModifier.class), name);
    }

    public static boolean isObjectAnnotatedWithName(VariableDeclarationExpression expression, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(expression.modifiers(), IExtendedModifier.class), name);
    }

    public static boolean isObjectAnnotatedWithName(VariableDeclarationStatement statement, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(statement.modifiers(), IExtendedModifier.class), name);
    }

    public static boolean isClassifierAnnotatedWithName(BodyDeclaration abstTypeDecl, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(abstTypeDecl.modifiers(), IExtendedModifier.class), name);
    }

    private static boolean containsAnnotationWithName(List<IExtendedModifier> modifiers, String name) {
        for (IExtendedModifier mod : modifiers) {
            Annotation anno;
            Name annoName;
            if (!mod.isAnnotation() || !(annoName = (anno = (Annotation)mod).getTypeName()).getFullyQualifiedName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static List<MethodDeclaration> getMethods(CompilationUnit unit) {
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            List<BodyDeclaration> bodies;
            if (abstType instanceof TypeDeclaration) {
                methods.addAll(RuleHelper.getMethods((TypeDeclaration)abstType));
                continue;
            }
            if (abstType instanceof EnumDeclaration) {
                EnumDeclaration enumDecl = (EnumDeclaration)abstType;
                bodies = RuleHelper.cast(enumDecl.bodyDeclarations(), BodyDeclaration.class);
                for (BodyDeclaration body : bodies) {
                    if (!(body instanceof MethodDeclaration)) continue;
                    methods.add((MethodDeclaration)body);
                }
                continue;
            }
            if (!(abstType instanceof AnnotationTypeDeclaration)) continue;
            AnnotationTypeDeclaration anno = (AnnotationTypeDeclaration)abstType;
            bodies = RuleHelper.cast(anno.bodyDeclarations(), BodyDeclaration.class);
            for (BodyDeclaration body : bodies) {
                if (!(body instanceof MethodDeclaration)) continue;
                methods.add((MethodDeclaration)body);
            }
        }
        return methods;
    }

    public static List<MethodDeclaration> getMethods(TypeDeclaration type) {
        return List.of(type.getMethods());
    }

    public static List<IMethodBinding> getMethods(Type type) {
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            LOG.warn((Object)("Could not resolve type binding for \"" + type + "\". Returning empty list for getMethods"));
            return List.of();
        }
        return List.of(binding.getDeclaredMethods());
    }

    public static List<FieldDeclaration> getFields(CompilationUnit unit) {
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            List<BodyDeclaration> bodies;
            if (abstType instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)abstType;
                fields.addAll(List.of(type.getFields()));
                continue;
            }
            if (abstType instanceof EnumDeclaration) {
                EnumDeclaration enumDecl = (EnumDeclaration)abstType;
                bodies = RuleHelper.cast(enumDecl.bodyDeclarations(), BodyDeclaration.class);
                for (BodyDeclaration body : bodies) {
                    if (!(body instanceof FieldDeclaration)) continue;
                    fields.add((FieldDeclaration)body);
                }
                continue;
            }
            if (!(abstType instanceof AnnotationTypeDeclaration)) continue;
            AnnotationTypeDeclaration anno = (AnnotationTypeDeclaration)abstType;
            bodies = RuleHelper.cast(anno.bodyDeclarations(), BodyDeclaration.class);
            for (BodyDeclaration body : bodies) {
                if (!(body instanceof FieldDeclaration)) continue;
                fields.add((FieldDeclaration)body);
            }
        }
        return fields;
    }

    public static List<SingleVariableDeclaration> getParameters(MethodDeclaration method) {
        return RuleHelper.cast(method.parameters(), SingleVariableDeclaration.class);
    }

    public static boolean isMethodAnnotatedWithName(MethodDeclaration method, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (RuleHelper.isObjectAnnotatedWithName((BodyDeclaration)method, name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isFieldAbstract(FieldDeclaration field) {
        Type type = field.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            LOG.warn((Object)("field: \"" + field + "\", has type binding null => returning false for isFieldAbstract"));
            return false;
        }
        return binding.isInterface();
    }

    public static boolean isParameterAbstract(SingleVariableDeclaration parameter) {
        Type type = parameter.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            LOG.warn((Object)("parameter: \"" + parameter + "\", has type binding null " + "=> returning false for isParameterAbstract"));
            return false;
        }
        return binding.isInterface();
    }

    public static boolean isParameterAClassAnnotatedWith(SingleVariableDeclaration parameter, String ... names) {
        Type type = parameter.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            LOG.warn((Object)("parameter: \"" + parameter + "\", has type binding null " + "=> returning false for isParameterAClassAnnotatedWith"));
            return false;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
            int n3 = iAnnotationBindingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotationBinding anno = iAnnotationBindingArray[n4];
                if (anno.getName().equals(name)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isFieldModifiedExactlyWith(BodyDeclaration field, String ... names) {
        return RuleHelper.areModifiersExactly(RuleHelper.cast(field.modifiers(), IExtendedModifier.class), names);
    }

    private static boolean areModifiersExactly(List<IExtendedModifier> modifiers, String ... names) {
        Set nameSet = Set.of(names).stream().map(x -> x.toLowerCase(Locale.US)).collect(Collectors.toSet());
        long exactModifierCount = modifiers.stream().filter(IExtendedModifier::isModifier).map(Modifier.class::cast).map(x -> x.getKeyword().toString().toLowerCase(Locale.US)).filter(nameSet::contains).count();
        return exactModifierCount == (long)names.length;
    }

    public static boolean isParameterAnnotatedWith(SingleVariableDeclaration parameter, String name) {
        return RuleHelper.isObjectAnnotatedWithName(parameter, name);
    }

    public static boolean isUnitNamedWith(CompilationUnit unit, String name) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration type : types) {
            if (!type.getName().getFullyQualifiedName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnitAnEnum(CompilationUnit unit) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration type : types) {
            if (!(type instanceof EnumDeclaration)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> getAllAbstractParents(CompilationUnit unit) {
        ArrayList<Type> interfaces = new ArrayList<Type>();
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            if (!(abstType instanceof TypeDeclaration var5_5)) continue;
            List<Type> interfaceTypes = RuleHelper.cast(type.superInterfaceTypes(), Type.class);
            interfaces.addAll(interfaceTypes);
            Type superclassType = type.getSuperclassType();
            if (superclassType == null || (superclassBinding = superclassType.resolveBinding()) == null || (superclassBinding.getModifiers() & 0x400) == 0) continue;
            interfaces.add(superclassType);
        }
        return interfaces;
    }

    public static boolean isFieldAnnotatedWithName(BodyDeclaration field, String name) {
        return RuleHelper.containsAnnotationWithName(RuleHelper.cast(field.modifiers(), IExtendedModifier.class), name);
    }

    public static boolean isClassImplementing(CompilationUnit unit) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            TypeDeclaration type;
            if (!(abstType instanceof TypeDeclaration) || (type = (TypeDeclaration)abstType).isInterface() || type.superInterfaceTypes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplementingOrExtending(CompilationUnit unit, String ifaceName) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            TypeDeclaration type;
            if (!(abstType instanceof TypeDeclaration) || !RuleHelper.isImplementingOrExtending((type = (TypeDeclaration)abstType).resolveBinding(), ifaceName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplementingOrExtending(ITypeBinding binding, String ifaceName) {
        if (binding == null) {
            LOG.warn((Object)("binding is null => returning false for isImplementingOrExtending(binding, \"" + ifaceName + "\")"));
            return false;
        }
        if (RuleHelper.equalsWithGeneric(binding.getName(), ifaceName)) {
            return true;
        }
        ITypeBinding superClass = binding.getSuperclass();
        if (superClass != null && RuleHelper.isImplementingOrExtending(superClass, ifaceName)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            if (RuleHelper.equalsWithGeneric(type.getName(), ifaceName) || RuleHelper.isImplementingOrExtending(type, ifaceName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean equalsWithGeneric(String withGeneric, String withoutGeneric) {
        if (!withGeneric.startsWith(withoutGeneric)) {
            return false;
        }
        String rest = withGeneric.substring(withoutGeneric.length());
        return rest.isEmpty() || rest.startsWith("<") && rest.endsWith(">");
    }

    public static boolean isClassExtending(CompilationUnit unit) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            TypeDeclaration type;
            if (!(abstType instanceof TypeDeclaration) || (type = (TypeDeclaration)abstType).isInterface() || type.getSuperclassType() == null) continue;
            return true;
        }
        return false;
    }

    public static Type getExtends(CompilationUnit unit) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            Type superclass;
            TypeDeclaration type;
            if (!(abstType instanceof TypeDeclaration) || (type = (TypeDeclaration)abstType).isInterface() || (superclass = type.getSuperclassType()) == null) continue;
            return superclass;
        }
        return null;
    }

    public static boolean isClassModifiedExactlyWith(CompilationUnit unit, String ... names) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        for (AbstractTypeDeclaration abstType : types) {
            TypeDeclaration type;
            if (!(abstType instanceof TypeDeclaration) || (type = (TypeDeclaration)abstType).isInterface()) continue;
            return RuleHelper.areModifiersExactly(RuleHelper.cast(type.modifiers(), IExtendedModifier.class), names);
        }
        return false;
    }

    public static boolean isMethodModifiedExactlyWith(BodyDeclaration method, String ... names) {
        return RuleHelper.areModifiersExactly(RuleHelper.cast(method.modifiers(), IExtendedModifier.class), names);
    }

    public static List<MethodDeclaration> getAllPublicMethods(CompilationUnit unit) {
        return RuleHelper.getMethods(unit).stream().filter(MethodDeclaration::isConstructor).filter(x -> RuleHelper.cast(x.modifiers(), IExtendedModifier.class).stream().filter(IExtendedModifier::isModifier).map(Modifier.class::cast).anyMatch(Modifier::isPublic)).collect(Collectors.toList());
    }

    public static List<MethodDeclaration> getConstructors(CompilationUnit unit) {
        return RuleHelper.getMethods(unit).stream().filter(MethodDeclaration::isConstructor).collect(Collectors.toList());
    }

    public static boolean isConstructorAnnotatedWithName(MethodDeclaration constructor, String name) {
        if (!constructor.isConstructor()) {
            return false;
        }
        return RuleHelper.isMethodAnnotatedWithName(constructor, name);
    }

    public static boolean isClassOfFieldAnnotatedWithName(FieldDeclaration field, String ... names) {
        ITypeBinding binding = field.getType().resolveBinding();
        if (binding == null) {
            LOG.warn((Object)("field: could not resolve type binding for \"" + field.getType() + "\" => returning false from isClassOfFieldAnnotatedWithName"));
            return false;
        }
        IAnnotationBinding[] annotations = binding.getAnnotations();
        Set<String> uniqueNames = Set.of(names);
        return List.of(annotations).stream().map(IAnnotationBinding::getName).anyMatch(uniqueNames::contains);
    }

    public static String getMethodAnnotationStringValue(MethodDeclaration method, String annotation) {
        return RuleHelper.getMethodAnnotationStringValue(method, annotation, "value");
    }

    public static String getMethodAnnotationStringValue(MethodDeclaration method, String annotationName, String memberName) {
        List annotations = RuleHelper.cast(method.modifiers(), IExtendedModifier.class).stream().filter(x -> x.isAnnotation()).map(Annotation.class::cast).filter(x -> x.getTypeName().getFullyQualifiedName().endsWith(annotationName)).collect(Collectors.toList());
        for (Annotation annotation : annotations) {
            Expression expression = null;
            if (annotation.isSingleMemberAnnotation()) {
                SingleMemberAnnotation smAnnotation = (SingleMemberAnnotation)annotation;
                expression = smAnnotation.getValue();
            } else if (annotation.isNormalAnnotation()) {
                NormalAnnotation nAnnotation = (NormalAnnotation)annotation;
                expression = RuleHelper.cast(nAnnotation.values(), MemberValuePair.class).stream().filter(x -> x.getName().getIdentifier().equals(memberName)).map(x -> x.getValue()).findFirst().orElse(null);
            } else if (annotation.isMarkerAnnotation()) {
                return "";
            }
            if (expression == null) {
                return "";
            }
            if (expression instanceof StringLiteral) {
                return ((StringLiteral)expression).getLiteralValue();
            }
            Object compiledValue = expression.resolveConstantExpressionValue();
            if (compiledValue == null) continue;
            return compiledValue.toString();
        }
        return null;
    }

    public static String getUnitAnnotationStringValue(CompilationUnit unit, String annotation) {
        return RuleHelper.getUnitAnnotationStringValue(unit, annotation, "value");
    }

    public static String getUnitAnnotationStringValue(CompilationUnit unit, String annotationName, String memberName) {
        List<AbstractTypeDeclaration> types = RuleHelper.cast(unit.types(), AbstractTypeDeclaration.class);
        List annotations = types.stream().map(y -> RuleHelper.cast(y.modifiers(), IExtendedModifier.class).stream().filter(x -> x.isAnnotation()).map(Annotation.class::cast).filter(x -> x.getTypeName().getFullyQualifiedName().endsWith(annotationName)).collect(Collectors.toList())).collect(() -> new ArrayList(), (acc, x) -> {
            boolean bl = acc.addAll(x);
        }, (acc1, acc2) -> {
            boolean bl = acc1.addAll(acc2);
        });
        for (Annotation annotation : annotations) {
            Expression expression = null;
            if (annotation.isSingleMemberAnnotation()) {
                SingleMemberAnnotation smAnnotation = (SingleMemberAnnotation)annotation;
                expression = smAnnotation.getValue();
            } else if (annotation.isNormalAnnotation()) {
                NormalAnnotation nAnnotation = (NormalAnnotation)annotation;
                expression = RuleHelper.cast(nAnnotation.values(), MemberValuePair.class).stream().filter(x -> x.getName().getIdentifier().equals(memberName)).map(x -> x.getValue()).findFirst().orElse(null);
            }
            if (expression == null || !(expression instanceof StringLiteral)) continue;
            return ((StringLiteral)expression).getLiteralValue();
        }
        return null;
    }

    private static <T> List<T> cast(List list, Class<T> clazz) {
        if (!list.isEmpty() && !clazz.isInstance(list.get(0))) {
            throw new ClassCastException("Illegal cast in EclipseRuleHelper!\n" + list.get(0).getClass() + " -> " + clazz);
        }
        return list;
    }
}

