/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.palladiosimulator.generator.fluent.repository.api.Repo;
import org.palladiosimulator.generator.fluent.repository.factory.FluentRepositoryFactory;
import org.palladiosimulator.generator.fluent.repository.structure.components.BasicComponentCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.CompositeComponentCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.Interface;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationInterfaceCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationSignatureCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.Primitive;
import org.palladiosimulator.generator.fluent.repository.structure.types.CompositeDataTypeCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ParameterModifier;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.retriever.extraction.commonalities.Component;
import org.palladiosimulator.retriever.extraction.commonalities.Composite;
import org.palladiosimulator.retriever.extraction.commonalities.Operation;
import org.palladiosimulator.retriever.extraction.commonalities.PCMDetectionResult;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class PCMInstanceCreator {
    private static final Logger LOG = Logger.getLogger(PCMInstanceCreator.class);
    private static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";
    private static final String REPO_NAME = "Software Architecture Repository";
    private final FluentRepositoryFactory create;
    private final Repo repository;
    private final RetrieverBlackboard blackboard;
    private final Map<String, CompositeDataTypeCreator> existingDataTypesMap = new HashMap<String, CompositeDataTypeCreator>();
    private final Map<String, DataType> existingCollectionDataTypes = new HashMap<String, DataType>();
    private final Map<Component, CompositeComponentCreator> componentCompositeCreators = new HashMap<Component, CompositeComponentCreator>();
    private final Map<String, CompositeComponentCreator> ifaceCompositeCreators = new HashMap<String, CompositeComponentCreator>();
    private final Map<Composite, CompositeComponentCreator> compositeCreators = new HashMap<Composite, CompositeComponentCreator>();
    private final Map<org.palladiosimulator.retriever.extraction.commonalities.OperationInterface, OperationInterface> pcmInterfaces = new HashMap<org.palladiosimulator.retriever.extraction.commonalities.OperationInterface, OperationInterface>();

    public PCMInstanceCreator(RetrieverBlackboard blackboard) {
        this.create = new FluentRepositoryFactory();
        this.repository = this.create.newRepository().withName(REPO_NAME);
        this.blackboard = blackboard;
    }

    private <K, V> void put(Map<K, List<V>> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        map.get(key).add(value);
    }

    public Repository createPCM(Map<String, Set<CompilationUnit>> mapping) {
        PCMDetectionResult detectionResult = ((PCMDetector)this.blackboard.getPCMDetector()).getResult();
        Set<Component> components = detectionResult.getComponents();
        Map<org.palladiosimulator.retriever.extraction.commonalities.OperationInterface, Set<Operation>> interfaces = detectionResult.getOperationInterfaces();
        Set<Composite> composites = detectionResult.getCompositeComponents();
        this.createPCMInterfaces(interfaces);
        HashMap<String, Integer> compositeComponentNames = new HashMap<String, Integer>();
        for (Composite composite : composites) {
            compositeComponentNames.put(composite.name(), 1 + compositeComponentNames.getOrDefault(composite.name(), 0));
        }
        for (Composite composite : composites) {
            String name = composite.name();
            int nameOccurrences = (Integer)compositeComponentNames.get(name);
            if (nameOccurrences > 1) {
                compositeComponentNames.put(name, nameOccurrences - 1);
                name = String.valueOf(name) + " " + nameOccurrences;
            }
            CompositeComponentCreator c = this.create.newCompositeComponent().withName(name.replace(".", "_"));
            composite.parts().forEach(x -> {
                CompositeComponentCreator compositeComponentCreator2 = this.componentCompositeCreators.put((Component)x, c);
            });
            composite.internalInterfaces().forEach(x -> {
                CompositeComponentCreator compositeComponentCreator2 = this.ifaceCompositeCreators.put(x.getInterface(), c);
            });
            this.compositeCreators.put(composite, c);
            HashSet<OperationInterface> distinctInterfaces = new HashSet<OperationInterface>();
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface compRequirement : composite.requirements()) {
                OperationInterface operationInterface = this.pcmInterfaces.get(compRequirement);
                if (distinctInterfaces.contains(operationInterface)) continue;
                distinctInterfaces.add(operationInterface);
                c.requires(operationInterface);
            }
            distinctInterfaces.clear();
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface compProvision : composite.provisions()) {
                OperationInterface operationInterface = this.pcmInterfaces.get(compProvision);
                if (distinctInterfaces.contains(operationInterface)) continue;
                distinctInterfaces.add(operationInterface);
                c.provides(operationInterface);
            }
        }
        this.createPCMComponents(components);
        for (Composite composite : composites) {
            CompositeComponentCreator c = this.compositeCreators.get(composite);
            CompositeComponent builtComp = (CompositeComponent)c.build();
            HashMap innerRequirements = new HashMap();
            HashMap innerProvisions = new HashMap();
            builtComp.getAssemblyContexts__ComposedStructure().stream().forEach(x -> x.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity().stream().map(OperationRequiredRole.class::cast).forEach(y -> this.put(innerRequirements, y.getRequiredInterface__OperationRequiredRole().getEntityName(), new Pair<OperationRequiredRole, AssemblyContext>((OperationRequiredRole)y, (AssemblyContext)x))));
            builtComp.getAssemblyContexts__ComposedStructure().stream().forEach(x -> x.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream().map(OperationProvidedRole.class::cast).forEach(y -> this.put(innerProvisions, y.getProvidedInterface__OperationProvidedRole().getEntityName(), new Pair<OperationProvidedRole, AssemblyContext>((OperationProvidedRole)y, (AssemblyContext)x))));
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface internalInterface : composite.internalInterfaces()) {
                String string = internalInterface.getInterface();
                for (Pair r : innerRequirements.getOrDefault(string, List.of())) {
                    for (Pair p : innerProvisions.getOrDefault(string, List.of())) {
                        if (((AssemblyContext)r.getT2()).equals(p.getT2())) continue;
                        c.withAssemblyConnection((OperationProvidedRole)p.getT1(), (AssemblyContext)p.getT2(), (OperationRequiredRole)r.getT1(), (AssemblyContext)r.getT2());
                    }
                }
            }
            HashMap outerRequirements = new HashMap();
            builtComp.getRequiredRoles_InterfaceRequiringEntity().stream().map(OperationRequiredRole.class::cast).forEach(x -> {
                OperationRequiredRole operationRequiredRole = outerRequirements.put(x.getRequiredInterface__OperationRequiredRole().getEntityName(), x);
            });
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface operationInterface : composite.requirements()) {
                String requiredInterfaceName = operationInterface.getName().toString().replace(".", "_");
                for (Pair r : innerRequirements.getOrDefault(requiredInterfaceName, List.of())) {
                    c.withRequiredDelegationConnection((AssemblyContext)r.getT2(), (OperationRequiredRole)r.getT1(), (OperationRequiredRole)outerRequirements.get(requiredInterfaceName));
                }
            }
            HashMap hashMap = new HashMap();
            builtComp.getProvidedRoles_InterfaceProvidingEntity().stream().map(OperationProvidedRole.class::cast).forEach(x -> {
                OperationProvidedRole operationProvidedRole = outerProvisions.put(x.getProvidedInterface__OperationProvidedRole().getEntityName(), x);
            });
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface providedInterface : composite.provisions()) {
                String providedInterfaceName = providedInterface.getName().toString().replace(".", "_");
                for (Pair r : innerProvisions.getOrDefault(providedInterfaceName, List.of())) {
                    c.withProvidedDelegationConnection((AssemblyContext)r.getT2(), (OperationProvidedRole)r.getT1(), (OperationProvidedRole)hashMap.get(providedInterfaceName));
                }
            }
            this.repository.addToRepository((org.palladiosimulator.generator.fluent.repository.structure.components.Component)c);
        }
        return this.repository.createRepositoryNow();
    }

    private void createPCMInterfaces(Map<org.palladiosimulator.retriever.extraction.commonalities.OperationInterface, Set<Operation>> interfaces) {
        HashMap interfaceNameRegistry = new HashMap();
        HashMap signatureNameRegistry = new HashMap();
        interfaces.forEach((inter, operations) -> {
            String interName = inter.getName().toString();
            LOG.info((Object)("Current PCM Interface: " + interName));
            String pcmInterfaceName = PCMInstanceCreator.prepareUniquePCMName(interName, interfaceNameRegistry);
            OperationInterfaceCreator pcmInterface = this.create.newOperationInterface().withName(pcmInterfaceName);
            for (Operation operation : operations) {
                String operationName = operation.getName().forInterface(interName).orElseThrow();
                String pcmOperationName = PCMInstanceCreator.prepareUniquePCMName(operationName, signatureNameRegistry);
                OperationSignatureCreator signature = this.create.newOperationSignature().withName(pcmOperationName);
                IMethodBinding method = operation.getBinding();
                if (method != null) {
                    ITypeBinding[] parameterTypes = method.getParameterTypes();
                    String[] parameterNames = method.getParameterNames();
                    int i = 0;
                    while (i < parameterTypes.length) {
                        ITypeBinding parameter = parameterTypes[i];
                        String parameterName = i < parameterNames.length ? parameterNames[i] : "parameter" + i;
                        signature = this.handleSignatureDataType(signature, parameterName, parameter, parameter.getDimensions(), false);
                        ++i;
                    }
                    ITypeBinding returned = method.getReturnType();
                    signature = this.handleSignatureDataType(signature, "", returned, returned.getDimensions(), true);
                }
                pcmInterface.withOperationSignature(signature);
                Optional<ASTNode> astNode = this.getDeclaration(method);
                if (!astNode.isPresent() || this.blackboard.getSeffAssociation(astNode.get()) != null) continue;
                ResourceDemandingSEFF seff = this.create.newSeff().onSignature(this.create.fetchOfSignature(pcmOperationName)).buildRDSeff();
                this.blackboard.putSeffAssociation(astNode.get(), (ServiceEffectSpecification)seff);
            }
            this.repository.addToRepository((Interface)pcmInterface);
            this.pcmInterfaces.put((org.palladiosimulator.retriever.extraction.commonalities.OperationInterface)inter, this.create.fetchOfOperationInterface(pcmInterfaceName));
        });
    }

    private static String prepareUniquePCMName(String name, Map<String, Integer> registry) {
        String pcmName = name.replace(".", "_");
        Integer numberOfOccurences = registry.getOrDefault(pcmName, 0);
        numberOfOccurences = numberOfOccurences + 1;
        registry.put(pcmName, numberOfOccurences);
        if (numberOfOccurences == 1) {
            return pcmName;
        }
        return String.valueOf(pcmName) + "$" + registry.get(name);
    }

    private Optional<ASTNode> getDeclaration(IMethodBinding binding) {
        return this.blackboard.getDiscoveredFiles(JAVA_DISCOVERER_ID, CompilationUnit.class).values().stream().map(unit -> unit.findDeclaringNode((IBinding)binding)).filter(node -> node != null).findAny();
    }

    private void createPCMComponents(Set<Component> components) {
        for (Component comp : components) {
            BasicComponentCreator pcmComp = this.create.newBasicComponent().withName(PCMInstanceCreator.wrapName(comp.name()));
            HashSet<OperationInterface> distinctInterfaces = new HashSet<OperationInterface>();
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface provision : comp.provisions().getGrouped().keySet()) {
                OperationInterface providedInterface = this.pcmInterfaces.get(provision);
                if (distinctInterfaces.contains(providedInterface)) continue;
                distinctInterfaces.add(providedInterface);
                pcmComp.provides(providedInterface, provision.toString());
            }
            comp.provisions().simplified().values().stream().flatMap(Collection::stream).forEach(operation -> {
                IMethodBinding method = operation.getBinding();
                Optional<ASTNode> declaration = this.getDeclaration(method);
                if (declaration.isPresent()) {
                    pcmComp.withServiceEffectSpecification(this.blackboard.getSeffAssociation(declaration.get()));
                }
            });
            distinctInterfaces.clear();
            for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface requirement : comp.requirements()) {
                for (OperationInterface requiredInterface : this.fetchInterfaces(requirement)) {
                    if (distinctInterfaces.contains(requiredInterface)) continue;
                    distinctInterfaces.add(requiredInterface);
                    pcmComp.requires(requiredInterface, requirement.getName().toString());
                }
            }
            BasicComponent builtComp = pcmComp.build();
            CompositeComponentCreator c = this.componentCompositeCreators.get(comp);
            if (c != null) {
                c.withAssemblyContext((RepositoryComponent)builtComp, new VariableUsageCreator[0]);
            }
            if (!comp.compilationUnit().isEmpty()) {
                this.blackboard.putRepositoryComponentLocation((RepositoryComponent)builtComp, comp.compilationUnit().get());
            }
            this.repository.addToRepository((RepositoryComponent)builtComp);
        }
    }

    private Collection<OperationInterface> fetchInterfaces(org.palladiosimulator.retriever.extraction.commonalities.OperationInterface iface) {
        HashSet<OperationInterface> result = new HashSet<OperationInterface>();
        if (this.pcmInterfaces.containsKey(iface)) {
            result.add(this.pcmInterfaces.get(iface));
        }
        for (org.palladiosimulator.retriever.extraction.commonalities.OperationInterface registeredInterface : this.pcmInterfaces.keySet()) {
            if (!iface.isPartOf(registeredInterface)) continue;
            result.add(this.pcmInterfaces.get(registeredInterface));
        }
        return result;
    }

    private static Primitive convertPrimitive(ITypeBinding primT) {
        switch (primT.getQualifiedName()) {
            case "boolean": {
                return Primitive.BOOLEAN;
            }
            case "byte": {
                return Primitive.BYTE;
            }
            case "char": {
                return Primitive.CHAR;
            }
            case "double": {
                return Primitive.DOUBLE;
            }
            case "float": {
                return Primitive.DOUBLE;
            }
            case "int": {
                return Primitive.INTEGER;
            }
            case "long": {
                return Primitive.LONG;
            }
            case "short": {
                return Primitive.INTEGER;
            }
        }
        return null;
    }

    private OperationSignatureCreator handleSignatureDataType(OperationSignatureCreator signature, String varName, ITypeBinding variable, int varDimensions, boolean asReturnType) {
        DataType collectionType = this.handleCollectionType(variable, varDimensions);
        if (collectionType != null) {
            if (asReturnType) {
                return signature.withReturnType(collectionType);
            }
            return signature.withParameter(varName, collectionType, ParameterModifier.IN);
        }
        Primitive prim = PCMInstanceCreator.handlePrimitive(variable);
        if (prim != null) {
            if (asReturnType) {
                return signature.withReturnType(prim);
            }
            return signature.withParameter(varName, prim, ParameterModifier.IN);
        }
        if ("void".equals(variable.getQualifiedName()) && asReturnType) {
            if (!this.create.containsDataType("Void")) {
                this.repository.addToRepository(this.create.newCompositeDataType().withName("Void"));
            }
            return signature.withReturnType(this.create.fetchOfDataType("Void"));
        }
        DataType compositeType = this.handleCompositeType(variable);
        if (compositeType != null) {
            if (asReturnType) {
                return signature.withReturnType(compositeType);
            }
            return signature.withParameter(varName, compositeType, ParameterModifier.IN);
        }
        return null;
    }

    private DataType handleCollectionType(ITypeBinding ref, int dimensions) {
        String typeName = PCMInstanceCreator.wrapName(ref);
        CollectionDataType collectionType = null;
        String collectionTypeName = null;
        if (dimensions != 0) {
            if (ref.isPrimitive()) {
                typeName = PCMInstanceCreator.convertPrimitive(ref).name();
            }
            if (this.existingCollectionDataTypes.containsKey(collectionTypeName = typeName)) {
                return this.existingCollectionDataTypes.get(collectionTypeName);
            }
            collectionType = this.createCollectionWithTypeArg(collectionTypeName, ref, dimensions - 1);
        } else if (PCMInstanceCreator.isCollectionType(ref) && ref.getTypeArguments().length > 0) {
            typeName = PCMInstanceCreator.wrapName(ref);
            ITypeBinding typeArg = ref.getTypeArguments()[0];
            String argumentTypeName = PCMInstanceCreator.wrapName(typeArg);
            collectionTypeName = String.valueOf(typeName) + "<" + argumentTypeName + ">";
            LOG.info((Object)("Current Argument type name: " + argumentTypeName));
            if (this.existingCollectionDataTypes.containsKey(collectionTypeName)) {
                return this.existingCollectionDataTypes.get(collectionTypeName);
            }
            collectionType = this.createCollectionWithTypeArg(collectionTypeName, typeArg, typeArg.getDimensions());
        }
        if (collectionType != null) {
            this.existingCollectionDataTypes.put(collectionTypeName, (DataType)collectionType);
            this.repository.addToRepository(collectionType);
        }
        return collectionType;
    }

    private CollectionDataType createCollectionWithTypeArg(String collectionTypeName, ITypeBinding typeArg, int typeArgDimensions) {
        Primitive primitiveArg = PCMInstanceCreator.handlePrimitive(typeArg);
        if (primitiveArg != null) {
            return this.create.newCollectionDataType(collectionTypeName, primitiveArg);
        }
        DataType collectionArg = this.handleCollectionType(typeArg, typeArgDimensions);
        if (collectionArg != null) {
            return FluentRepositoryFactory.newCollectionDataType((String)collectionTypeName, (DataType)collectionArg);
        }
        DataType compositeArg = this.handleCompositeType(typeArg);
        if (compositeArg != null) {
            return FluentRepositoryFactory.newCollectionDataType((String)collectionTypeName, (DataType)compositeArg);
        }
        return null;
    }

    private static boolean isCollectionType(ITypeBinding varClassifier) {
        ArrayList<ITypeBinding> refs = new ArrayList<ITypeBinding>();
        if (varClassifier.isClass()) {
            refs.addAll(List.of(varClassifier.getInterfaces()));
        } else if (varClassifier.isInterface()) {
            if ("java.util.Collection".equals(varClassifier.getQualifiedName())) {
                return true;
            }
            refs.addAll(List.of(varClassifier.getInterfaces()));
        }
        for (ITypeBinding ref : refs) {
            if (!"java.util.Collection".equals(ref.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static Primitive handlePrimitive(ITypeBinding variable) {
        if (variable.isPrimitive()) {
            return PCMInstanceCreator.convertPrimitive(variable);
        }
        if ("java.lang.String".equals(variable.getQualifiedName())) {
            return Primitive.STRING;
        }
        return null;
    }

    private DataType handleCompositeType(ITypeBinding ref) {
        String classifierName = PCMInstanceCreator.wrapName(ref);
        if (!this.existingDataTypesMap.containsKey(classifierName)) {
            this.existingDataTypesMap.put(classifierName, this.create.newCompositeDataType().withName(classifierName));
            this.repository.addToRepository(this.existingDataTypesMap.get(classifierName));
        }
        return this.create.fetchOfCompositeDataType(classifierName);
    }

    private static String wrapName(ITypeBinding name) {
        return PCMInstanceCreator.wrapName(name.getQualifiedName());
    }

    private static String wrapName(String name) {
        String fullName = name.replace(".", "_");
        if (fullName.contains("<")) {
            return fullName.substring(0, fullName.indexOf(60));
        }
        return fullName;
    }

    private class Pair<T1, T2> {
        private final T1 t1;
        private final T2 t2;

        public Pair(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public T1 getT1() {
            return this.t1;
        }

        public T2 getT2() {
            return this.t2;
        }
    }
}

