/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.mocore.processor.relation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.palladiosimulator.retriever.mocore.surrogate.PcmSurrogate;
import org.palladiosimulator.retriever.mocore.surrogate.element.Component;
import org.palladiosimulator.retriever.mocore.surrogate.element.Deployment;
import org.palladiosimulator.retriever.mocore.surrogate.element.Interface;
import org.palladiosimulator.retriever.mocore.surrogate.relation.ComponentAllocationRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.ComponentAssemblyRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.DeploymentDeploymentRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.InterfaceProvisionRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.InterfaceRequirementRelation;
import tools.mdsd.mocore.framework.processor.RelationProcessor;
import tools.mdsd.mocore.framework.surrogate.Model;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.surrogate.Replaceable;

public class ComponentAssemblyRelationProcessor
extends RelationProcessor<PcmSurrogate, ComponentAssemblyRelation> {
    public ComponentAssemblyRelationProcessor(PcmSurrogate model) {
        super((Model)model, ComponentAssemblyRelation.class);
    }

    protected void refine(ComponentAssemblyRelation discovery) {
        Object allocation;
        Deployment placeholderDeployment;
        Component provider = (Component)((InterfaceProvisionRelation)discovery.getSource()).getSource();
        Component consumer = (Component)((InterfaceRequirementRelation)discovery.getDestination()).getSource();
        Interface providerConsumerInterface = (Interface)((InterfaceProvisionRelation)discovery.getSource()).getDestination();
        List<Deployment> providerAllocations = this.getAllocatedContainers(provider);
        List<Deployment> consumerAllocations = this.getAllocatedContainers(consumer);
        if (providerAllocations.isEmpty()) {
            placeholderDeployment = Deployment.getUniquePlaceholder();
            allocation = new ComponentAllocationRelation(provider, placeholderDeployment, true);
            providerAllocations.add(placeholderDeployment);
            this.addImplication((Replaceable)allocation);
        }
        if (consumerAllocations.isEmpty()) {
            placeholderDeployment = Deployment.getUniquePlaceholder();
            allocation = new ComponentAllocationRelation(consumer, placeholderDeployment, true);
            consumerAllocations.add(placeholderDeployment);
            this.addImplication((Replaceable)allocation);
        }
        for (Deployment providerContainer : providerAllocations) {
            for (Deployment consumerContainer : consumerAllocations) {
                if (providerContainer.equals((Object)consumerContainer)) continue;
                DeploymentDeploymentRelation containerLink = new DeploymentDeploymentRelation(providerContainer, consumerContainer, true);
                this.addImplication((Replaceable)containerLink);
            }
        }
        List assemblies = ((PcmSurrogate)this.getModel()).getByType(ComponentAssemblyRelation.class);
        assemblies.removeIf(assembly -> !((InterfaceProvisionRelation)assembly.getSource()).isPlaceholder() || !((InterfaceRequirementRelation)assembly.getDestination()).isPlaceholder());
        for (ComponentAssemblyRelation placeholderAssembly : assemblies) {
            boolean isInverseAssembly;
            if (discovery.equals((Object)placeholderAssembly)) continue;
            Component source = (Component)((InterfaceProvisionRelation)placeholderAssembly.getSource()).getSource();
            Component destination = (Component)((InterfaceRequirementRelation)placeholderAssembly.getDestination()).getSource();
            Interface sourceDestinationInterface = (Interface)((InterfaceProvisionRelation)placeholderAssembly.getSource()).getDestination();
            Optional optionalSourceContainer = this.getAllocatedContainers(source).stream().findFirst();
            Optional optionalDestinationContainer = this.getAllocatedContainers(destination).stream().findFirst();
            if (!optionalSourceContainer.isPresent() || !optionalDestinationContainer.isPresent()) continue;
            Deployment sourceContainer = (Deployment)((Object)optionalSourceContainer.get());
            Deployment destinationContainer = (Deployment)((Object)optionalDestinationContainer.get());
            boolean isParallelAssembly = providerAllocations.contains((Object)sourceContainer) && consumerAllocations.contains((Object)destinationContainer);
            boolean bl = isInverseAssembly = providerAllocations.contains((Object)destinationContainer) && consumerAllocations.contains((Object)sourceContainer);
            if (!isParallelAssembly && !isInverseAssembly) continue;
            this.addImplications(((PcmSurrogate)this.getModel()).replace((Replaceable)placeholderAssembly, (Replaceable)discovery));
            this.addImplications(((PcmSurrogate)this.getModel()).replace((Replaceable)source, (Replaceable)provider));
            this.addImplications(((PcmSurrogate)this.getModel()).replace((Replaceable)destination, (Replaceable)consumer));
            this.addImplications(((PcmSurrogate)this.getModel()).replace((Replaceable)sourceDestinationInterface, (Replaceable)providerConsumerInterface));
        }
        super.refine((Relation)discovery);
    }

    private List<Deployment> getAllocatedContainers(Component<?> component) {
        List allocations = ((PcmSurrogate)this.getModel()).getByType(ComponentAllocationRelation.class);
        return allocations.stream().filter(allocation -> ((Component)allocation.getSource()).equals(component)).map(Relation::getDestination).collect(Collectors.toList());
    }
}

