/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.mocore.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.retriever.mocore.discovery.RepositoryDecompositor;
import org.palladiosimulator.retriever.mocore.orchestration.PcmOrchestrator;
import org.palladiosimulator.retriever.mocore.surrogate.PcmSurrogate;
import org.palladiosimulator.retriever.mocore.transformation.AllocationTransformer;
import org.palladiosimulator.retriever.mocore.transformation.RepositoryTransformer;
import org.palladiosimulator.retriever.mocore.transformation.ResourceEnvironmentTransformer;
import org.palladiosimulator.retriever.mocore.transformation.SystemTransformer;
import tools.mdsd.mocore.framework.discovery.Discoverer;

public class MoCoReJob
implements IBlackboardInteractingJob<Blackboard<Object>> {
    private static final String JOB_NAME = "Model Composition & Refinement Job";
    private Blackboard<Object> blackboard;
    private final String repositoryInputKey;
    private final String repositoryOutputKey;
    private final String systemOutputKey;
    private final String allocationOutputKey;
    private final String resourceEnvironmentOutputKey;

    public MoCoReJob(Blackboard<Object> blackboard, String repositoryInputKey, String repositoryOutputKey, String systemOutputKey, String allocationOutputKey, String resourceEnvironmentOutputKey) {
        this.blackboard = Objects.requireNonNull(blackboard);
        this.repositoryInputKey = Objects.requireNonNull(repositoryInputKey);
        this.repositoryOutputKey = Objects.requireNonNull(repositoryOutputKey);
        this.systemOutputKey = Objects.requireNonNull(systemOutputKey);
        this.allocationOutputKey = Objects.requireNonNull(allocationOutputKey);
        this.resourceEnvironmentOutputKey = Objects.requireNonNull(resourceEnvironmentOutputKey);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.subTask("Retrieving job input from blackboard");
        Repository inputRepository = (Repository)this.blackboard.getPartition(this.repositoryInputKey);
        monitor.subTask("Converting input into processable discoveries");
        RepositoryDecompositor repositoryDecompositor = new RepositoryDecompositor();
        Collection<Discoverer<?>> discoverers = repositoryDecompositor.decompose(inputRepository);
        monitor.subTask("Processing discoveries");
        PcmOrchestrator orchestrator = new PcmOrchestrator();
        discoverers.forEach(arg_0 -> ((PcmOrchestrator)orchestrator).processDiscoverer(arg_0));
        monitor.subTask("Transforming surrogate model into output models");
        PcmSurrogate surrogate = (PcmSurrogate)orchestrator.getModel();
        Repository repository = new RepositoryTransformer().transform(surrogate);
        System system = new SystemTransformer().transform(surrogate, repository);
        ResourceEnvironment resourceEnvironment = new ResourceEnvironmentTransformer().transform(surrogate);
        Allocation allocation = new AllocationTransformer().transform(surrogate, system, resourceEnvironment);
        monitor.subTask("Adding output models to blackboard");
        this.blackboard.addPartition(this.repositoryOutputKey, (Object)repository);
        this.blackboard.addPartition(this.systemOutputKey, (Object)system);
        this.blackboard.addPartition(this.allocationOutputKey, (Object)allocation);
        this.blackboard.addPartition(this.resourceEnvironmentOutputKey, (Object)resourceEnvironment);
        monitor.done();
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return JOB_NAME;
    }

    public void setBlackboard(Blackboard<Object> blackboard) {
        this.blackboard = Objects.requireNonNull(blackboard);
    }
}

