/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.mocore.transformation;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.palladiosimulator.generator.fluent.resourceenvironment.api.IResourceEnvironment;
import org.palladiosimulator.generator.fluent.resourceenvironment.factory.FluentResourceEnvironmentFactory;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.LinkingResourceCreator;
import org.palladiosimulator.generator.fluent.resourceenvironment.structure.ResourceContainerCreator;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.retriever.mocore.surrogate.PcmSurrogate;
import org.palladiosimulator.retriever.mocore.surrogate.element.Deployment;
import org.palladiosimulator.retriever.mocore.surrogate.element.LinkResourceSpecification;
import org.palladiosimulator.retriever.mocore.surrogate.relation.DeploymentDeploymentRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.LinkResourceSpecificationRelation;
import tools.mdsd.mocore.framework.transformation.Transformer;

public class ResourceEnvironmentTransformer
implements Transformer<PcmSurrogate, ResourceEnvironment> {
    public ResourceEnvironment transform(PcmSurrogate model) {
        FluentResourceEnvironmentFactory resourceEnvironmentFactory = new FluentResourceEnvironmentFactory();
        IResourceEnvironment fluentResourceEnvironment = resourceEnvironmentFactory.newResourceEnvironment();
        for (Deployment deployment : model.getByType(Deployment.class)) {
            ResourceContainerCreator containerCreator = this.getContainerCreator(resourceEnvironmentFactory, deployment);
            fluentResourceEnvironment.addToResourceEnvironment(containerCreator);
        }
        HashMultimap linkSpecificationMap = HashMultimap.create();
        for (LinkResourceSpecificationRelation linkingRelation : model.getByType(LinkResourceSpecificationRelation.class)) {
            Deployment source = (Deployment)((DeploymentDeploymentRelation)linkingRelation.getDestination()).getSource();
            Deployment destination = (Deployment)((DeploymentDeploymentRelation)linkingRelation.getDestination()).getDestination();
            LinkResourceSpecification specification = (LinkResourceSpecification)linkingRelation.getSource();
            if (source.equals((Object)destination)) continue;
            linkSpecificationMap.put((Object)specification, (Object)source);
            linkSpecificationMap.put((Object)specification, (Object)destination);
        }
        for (LinkResourceSpecification key : linkSpecificationMap.keySet()) {
            LinkingResourceCreator linkingResourceCreator = this.getLinkingResourceCreator(resourceEnvironmentFactory, linkSpecificationMap.get((Object)key));
            fluentResourceEnvironment.addToResourceEnvironment(linkingResourceCreator);
        }
        ResourceEnvironment resourceEnvironment = fluentResourceEnvironment.createResourceEnvironmentNow();
        for (ResourceContainer container : resourceEnvironment.getResourceContainer_ResourceEnvironment()) {
            for (Deployment deployment : model.getByType(Deployment.class)) {
                ResourceContainer wrappedContainer = (ResourceContainer)deployment.getValue();
                if (!container.getEntityName().equals(wrappedContainer.getEntityName())) continue;
                container.getActiveResourceSpecifications_ResourceContainer().addAll((Collection)wrappedContainer.getActiveResourceSpecifications_ResourceContainer());
                container.getHddResourceSpecifications().addAll((Collection)wrappedContainer.getHddResourceSpecifications());
            }
        }
        for (LinkResourceSpecification specification : linkSpecificationMap.keySet()) {
            Set deployments = linkSpecificationMap.get((Object)specification);
            for (LinkingResource linkingResource : resourceEnvironment.getLinkingResources__ResourceEnvironment()) {
                if (!Objects.equals(ResourceEnvironmentTransformer.getLinkingResourceName(deployments), linkingResource.getEntityName())) continue;
                linkingResource.setCommunicationLinkResourceSpecifications_LinkingResource((CommunicationLinkResourceSpecification)specification.getValue());
            }
        }
        return resourceEnvironment;
    }

    protected static String getLinkingResourceName(Collection<Deployment> deployments) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Deployment deployment : deployments) {
            stringBuilder.append(" " + ((ResourceContainer)deployment.getValue()).getEntityName());
        }
        stringBuilder.append(" Link");
        return stringBuilder.toString();
    }

    private ResourceContainerCreator getContainerCreator(FluentResourceEnvironmentFactory fluentFactory, Deployment deployment) {
        ResourceContainer wrappedContainer = (ResourceContainer)deployment.getValue();
        ResourceContainerCreator containerCreator = fluentFactory.newResourceContainer().withName(wrappedContainer.getEntityName());
        return containerCreator;
    }

    private LinkingResourceCreator getLinkingResourceCreator(FluentResourceEnvironmentFactory fluentFactory, Collection<Deployment> deployments) {
        String entityName = ResourceEnvironmentTransformer.getLinkingResourceName(deployments);
        LinkingResourceCreator creator = fluentFactory.newLinkingResource().withName(entityName);
        for (Deployment deployment : deployments) {
            String containerName = ((ResourceContainer)deployment.getValue()).getEntityName();
            creator.addLinkedResourceContainer(containerName);
        }
        return creator;
    }
}

