/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.services;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.palladiosimulator.retriever.services.Service;
import org.palladiosimulator.retriever.services.ServiceCollection;

public class ServiceConfiguration<T extends Service> {
    private final String selectedServicesKey;
    private final String serviceConfigKeyPrefix;
    private final Map<String, Map<String, String>> serviceConfigs;
    private final Map<String, T> services;
    private final Set<T> manuallySelectedServices;
    private final Map<T, Set<Service>> selectedDependencies;
    private final Set<ServiceConfiguration<? extends Service>> dependencyProviders;

    public ServiceConfiguration(ServiceCollection<T> serviceCollection, String selectedServicesKey, String serviceConfigKeyPrefix) {
        this.selectedServicesKey = selectedServicesKey;
        this.serviceConfigKeyPrefix = serviceConfigKeyPrefix;
        this.serviceConfigs = new HashMap<String, Map<String, String>>();
        this.services = new HashMap<String, T>();
        for (Service service : serviceCollection.getServices()) {
            this.services.put(service.getID(), service);
            HashMap<String, String> initializedConfig = new HashMap<String, String>();
            for (String key : service.getConfigurationKeys()) {
                initializedConfig.put(key, "");
            }
            this.serviceConfigs.put(service.getID(), initializedConfig);
        }
        this.manuallySelectedServices = new HashSet<T>();
        this.selectedDependencies = new HashMap<T, Set<Service>>();
        this.dependencyProviders = new HashSet<ServiceConfiguration<? extends Service>>();
        this.dependencyProviders.add(this);
    }

    public void addDependencyProvider(ServiceConfiguration<? extends Service> dependencyProvider) {
        this.dependencyProviders.add(dependencyProvider);
    }

    public void applyAttributeMap(Map<String, Object> attributeMap) {
        Set serviceIds = (Set)attributeMap.get(this.selectedServicesKey);
        for (Map.Entry<String, T> serviceEntry : this.services.entrySet()) {
            String serviceId = serviceEntry.getKey();
            Service service = (Service)serviceEntry.getValue();
            if (attributeMap.get(String.valueOf(this.serviceConfigKeyPrefix) + serviceId) != null) {
                this.serviceConfigs.put(serviceId, (Map)attributeMap.get(String.valueOf(this.serviceConfigKeyPrefix) + serviceId));
            }
            if (serviceIds == null || !serviceIds.contains(service.getID())) continue;
            this.select(service);
        }
    }

    public String getConfig(String serviceId, String key) {
        Map<String, String> config = this.serviceConfigs.get(serviceId);
        if (config == null) {
            return null;
        }
        return config.get(key);
    }

    public Map<String, String> getWholeConfig(String serviceId) {
        return Collections.unmodifiableMap(this.serviceConfigs.get(serviceId));
    }

    public void setConfig(String serviceId, String key, String value) {
        Map<String, String> config = this.serviceConfigs.get(serviceId);
        if (config == null) {
            config = new HashMap<String, String>();
            this.serviceConfigs.put(serviceId, config);
        }
        config.put(key, value);
    }

    public void select(T service) {
        this.manuallySelectedServices.add(service);
        for (ServiceConfiguration<? extends Service> dependencyProvider : this.dependencyProviders) {
            dependencyProvider.selectDependenciesOf((Service)service);
        }
    }

    public void deselect(T service) {
        this.manuallySelectedServices.remove(service);
        for (ServiceConfiguration<? extends Service> dependencyProvider : this.dependencyProviders) {
            dependencyProvider.deselectDependenciesOf((Service)service);
        }
    }

    public boolean isManuallySelected(T service) {
        return this.manuallySelectedServices.contains(service);
    }

    public Set<T> getSelected() {
        HashSet<T> selectedServices = new HashSet<T>(this.manuallySelectedServices);
        selectedServices.addAll(this.selectedDependencies.keySet());
        return Collections.unmodifiableSet(selectedServices);
    }

    public Queue<Collection<T>> getExecutionOrder() {
        ArrayList<Collection<T>> executionOrder = new ArrayList<Collection<T>>();
        ArrayDeque<T> remainingServices = new ArrayDeque<T>(this.getSelected());
        LinkedList<Service> requiringServices = new LinkedList<Service>();
        HashMap extendedRequirements = new HashMap();
        HashSet<String> selectedIDs = new HashSet<String>();
        for (Service service : remainingServices) {
            selectedIDs.add(service.getID());
        }
        for (Service service : remainingServices) {
            Set<String> requiredServices = service.getRequiredServices();
            if (requiredServices.stream().anyMatch(x -> x == null)) {
                extendedRequirements.put(service.getID(), new HashSet(selectedIDs));
                continue;
            }
            extendedRequirements.put(service.getID(), new HashSet<String>(requiredServices));
        }
        for (Service providingService : remainingServices) {
            for (String dependentID : providingService.getDependentServices()) {
                if (!extendedRequirements.containsKey(dependentID)) continue;
                ((Set)extendedRequirements.get(dependentID)).add(providingService.getID());
            }
        }
        while (!remainingServices.isEmpty()) {
            Service candidate = (Service)remainingServices.poll();
            String candidateID = candidate.getID();
            Set candidateRequirements = (Set)extendedRequirements.get(candidateID);
            if (this.isRequiringAny(candidateRequirements, remainingServices) || this.isRequiringAny(candidateRequirements, requiringServices)) {
                requiringServices.add(candidate);
                continue;
            }
            this.addAfterRequirements(candidate, candidateRequirements, executionOrder);
            remainingServices.addAll(requiringServices);
            requiringServices.clear();
        }
        if (!requiringServices.isEmpty()) {
            throw new IllegalStateException("Dependency cycle in services, no possible execution order.");
        }
        return new ArrayDeque<Collection<T>>(executionOrder);
    }

    private void addAfterRequirements(T service, Set<String> serviceRequirements, List<Collection<T>> executionOrder) {
        if (executionOrder.isEmpty() || this.isRequiringAny(serviceRequirements, executionOrder.get(executionOrder.size() - 1))) {
            ArrayList<T> newStep = new ArrayList<T>();
            newStep.add(service);
            executionOrder.add(newStep);
            return;
        }
        Collection<T> earliestCandidate = executionOrder.get(executionOrder.size() - 1);
        int i = executionOrder.size() - 2;
        while (i >= 0) {
            Collection<T> currentStep = executionOrder.get(i);
            if (this.isRequiringAny(serviceRequirements, currentStep)) break;
            earliestCandidate = currentStep;
            --i;
        }
        earliestCandidate.add(service);
    }

    private boolean isRequiringAny(Set<String> requirements, Collection<T> services) {
        return services.stream().map(Service::getID).anyMatch(requirements::contains);
    }

    public Collection<T> getAvailable() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    public void selectDependenciesOf(Service service) {
        if (service == null) {
            return;
        }
        for (String dependencyID : service.getRequiredServices()) {
            if (!this.services.containsKey(dependencyID)) continue;
            Service dependency = (Service)this.services.get(dependencyID);
            this.addDependingService(dependency, service);
        }
    }

    private void addDependingService(T dependency, Service service) {
        if (this.selectedDependencies.containsKey(dependency)) {
            Set<Service> dependingServices = this.selectedDependencies.get(dependency);
            dependingServices.add(service);
        } else {
            HashSet<Service> dependingServices = new HashSet<Service>();
            dependingServices.add(service);
            this.selectedDependencies.put(dependency, dependingServices);
            for (ServiceConfiguration<? extends Service> dependencyProvider : this.dependencyProviders) {
                dependencyProvider.selectDependenciesOf((Service)dependency);
            }
        }
    }

    public void deselectDependenciesOf(Service service) {
        for (String dependencyID : service.getRequiredServices()) {
            if (!this.services.containsKey(dependencyID)) continue;
            Service dependency = (Service)this.services.get(dependencyID);
            this.removeDependingService(dependency, service);
        }
    }

    private void removeDependingService(T dependency, Service service) {
        if (!this.selectedDependencies.containsKey(dependency)) {
            return;
        }
        Set<Service> dependingServices = this.selectedDependencies.get(dependency);
        dependingServices.remove(service);
        if (dependingServices.isEmpty()) {
            this.selectedDependencies.remove(dependency);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String serviceId : this.serviceConfigs.keySet()) {
            result.put(String.valueOf(this.serviceConfigKeyPrefix) + serviceId, this.serviceConfigs.get(serviceId));
        }
        result.put(this.selectedServicesKey, ServiceConfiguration.serializeServices(this.manuallySelectedServices));
        return result;
    }

    private static Set<String> serializeServices(Iterable<? extends Service> services) {
        HashSet<String> serviceIds = new HashSet<String>();
        for (Service service : services) {
            serviceIds.add(service.getID());
        }
        return serviceIds;
    }
}

