/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.services;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.Service;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public interface Rule
extends Service {
    public void processRules(RetrieverBlackboard var1, Path var2);

    public boolean isBuildRule();

    @Override
    default public IBlackboardInteractingJob<RetrieverBlackboard> create(RetrieverConfiguration configuration, final RetrieverBlackboard blackboard) {
        final Rule rule = this;
        return new AbstractBlackboardInteractingJob<RetrieverBlackboard>(){

            public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
                for (Path path : blackboard.getDiscoveredPaths()) {
                    rule.processRules(blackboard, path);
                }
            }

            public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
            }

            public String getName() {
                return String.valueOf(rule.getName()) + " Job";
            }
        };
    }
}

