package org.palladiosimulator.retriever.vulnerability.analyst;

import java.util.Collections;
import java.util.Set;

import org.palladiosimulator.retriever.services.Analyst;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;

public class SnykCodeAnalyst implements Analyst {
    public static final String ANALYST_ID = "org.palladiosimulator.retriever.vulnerability.core.analyst";

    public static final String SNYK_EXE_LOCATION_KEY = "SNYK_EXE_LOCATION";
    public static final String DATABASE_API_KEY = "DATABASE_API_KEY";
    public static final String SNYK_TOKEN_KEY = "SNYK_TOKEN";

    private static final Set<String> CONFIGURATION_KEYS = Collections
        .unmodifiableSet(Set.of(SNYK_EXE_LOCATION_KEY, DATABASE_API_KEY, SNYK_TOKEN_KEY));

    @Override
    public IBlackboardInteractingJob<RetrieverBlackboard> create(RetrieverConfiguration configuration,
            RetrieverBlackboard blackboard) {
        return new SnykCodeAnalystJob(configuration, blackboard);
    }

    @Override
    public Set<String> getConfigurationKeys() {
        return CONFIGURATION_KEYS;
    }

    @Override
    public String getName() {
        return "Snyk Code Analyst";
    }

    @Override
    public String getID() {
        return ANALYST_ID;
    }

    @Override
    public Set<String> getRequiredServices() {
        return Set.of();
    }
}
