package org.palladiosimulator.retriever.vulnerability.core;

import java.util.List;

import org.palladiosimulator.retriever.vulnerability.core.api.IStaticCodeAnalysisIssue;
import org.palladiosimulator.retriever.vulnerability.core.api.IStaticCodeAnalysisResult;

public class StaticCodeAnalyisResult implements IStaticCodeAnalysisResult {

	private List<IStaticCodeAnalysisIssue> issues;
	private String packetManager;

	public StaticCodeAnalyisResult(List<IStaticCodeAnalysisIssue> issues, String packetManager) {
		this.issues = issues;
		this.packetManager = packetManager;
	}

	@Override
	public boolean gotIssues() {
		return this.issues != null && !this.issues.isEmpty();
	}

	@Override
	public List<IStaticCodeAnalysisIssue> getIssues() {
		return this.issues;
	}

	@Override
	public int getDependencyCount() {
		// TODO Implement
		return 0;
	}

	@Override
	public String getPacketManager() {
		return this.packetManager;
	}

}
