package org.palladiosimulator.retriever.vulnerability.core;

import java.util.Collections;
import java.util.Date;
import java.util.Map;

import org.palladiosimulator.retriever.vulnerability.core.api.IStaticCodeAnalysisIssue;

public class SnykIssue implements IStaticCodeAnalysisIssue {

    private static long nextId = 0;
    private long id = nextId++;

    private String url;
    private String title;
    private String packageWithIssue;
    private String severity;

    public SnykIssue(String url, String title, String packageWithIssue, String severity) {
        this.url = url;
        this.title = title;
        this.packageWithIssue = packageWithIssue;
        this.severity = severity;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String[] getPaths() {
        return new String[0];
    }

    @Override
    public String getPackage() {
        return this.packageWithIssue;
    }

    @Override
    public String getPackageVersion() {
        throw new UnsupportedOperationException("SnykIssues do not know about package versions!");
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public String getLanguage() {
        throw new UnsupportedOperationException(
                "SnykIssues do not know the programming language of the vulnerable code!");
    }

    @Override
    public Date getPublicationTime() {
        throw new UnsupportedOperationException("SnykIssues do not know the publication time of vulnerabilities!");
    }

    @Override
    public Date getDisclosureTime() {
        throw new UnsupportedOperationException("SnykIssues do not know the disclosure time of vulnerabilities!");
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("SnykIssues do not have descriptions!");
    }

    @Override
    public Map<String, String> getIdentifiers() {
        return Collections.emptyMap();
    }

    @Override
    public String getCVSSv3() {
        throw new UnsupportedOperationException("SnykIssues do not have a CVSSv3!");
    }

    @Override
    public float getCVSSScore() {
        throw new UnsupportedOperationException("SnykIssues do not have a CVSS score!");
    }

    @Override
    public String toString() {
        return String.format("%s (%s Severity) in %s", this.title, this.severity.toString(), this.packageWithIssue);
    }
}
