package org.palladiosimulator.retriever.vulnerability.core.api;

import java.util.List;

import org.palladiosimulator.pcm.confidentiality.attackerSpecification.CategorySpecification;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.CVEVulnerability;

/**
 * Interface for communication with a vulnerability database.
 */
public interface IVulnerabilityDatabase {
    /**
     * Returns a CVEVulnerability for the given identifier.
     * 
     * @param identifier
     *            of the vulnerability database entry
     * @return vulnerability
     * @throws VulnerabilityDatabaseException
     *             iff the access to the database failed
     */
    public CVEVulnerability getCVEVulnerability(String identifier, List<Integer> cweIdentifiers)
            throws VulnerabilityDatabaseException;

    /**
     * Returns a CategorySpecification containing all AttackCategories (CVEs and CWEs) recorded
     * until now.
     * 
     * @return categorySpecification
     */
    public CategorySpecification getCategorySpecification();
}
