/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.vulnerability.core.nvd;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

public class CvssV20Data {
    @SerializedName(value="version")
    @Expose
    private Version version;
    @SerializedName(value="vectorString")
    @Expose
    private String vectorString;
    @SerializedName(value="accessVector")
    @Expose
    private AccessVectorType accessVector;
    @SerializedName(value="accessComplexity")
    @Expose
    private AccessComplexityType accessComplexity;
    @SerializedName(value="authentication")
    @Expose
    private AuthenticationType authentication;
    @SerializedName(value="confidentialityImpact")
    @Expose
    private CiaType confidentialityImpact;
    @SerializedName(value="integrityImpact")
    @Expose
    private CiaType integrityImpact;
    @SerializedName(value="availabilityImpact")
    @Expose
    private CiaType availabilityImpact;
    @SerializedName(value="baseScore")
    @Expose
    private Double baseScore;
    @SerializedName(value="exploitability")
    @Expose
    private ExploitabilityType exploitability;
    @SerializedName(value="remediationLevel")
    @Expose
    private RemediationLevelType remediationLevel;
    @SerializedName(value="reportConfidence")
    @Expose
    private ReportConfidenceType reportConfidence;
    @SerializedName(value="temporalScore")
    @Expose
    private Double temporalScore;
    @SerializedName(value="collateralDamagePotential")
    @Expose
    private CollateralDamagePotentialType collateralDamagePotential;
    @SerializedName(value="targetDistribution")
    @Expose
    private TargetDistributionType targetDistribution;
    @SerializedName(value="confidentialityRequirement")
    @Expose
    private CiaRequirementType confidentialityRequirement;
    @SerializedName(value="integrityRequirement")
    @Expose
    private CiaRequirementType integrityRequirement;
    @SerializedName(value="availabilityRequirement")
    @Expose
    private CiaRequirementType availabilityRequirement;
    @SerializedName(value="environmentalScore")
    @Expose
    private Double environmentalScore;

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getVectorString() {
        return this.vectorString;
    }

    public void setVectorString(String vectorString) {
        this.vectorString = vectorString;
    }

    public AccessVectorType getAccessVector() {
        return this.accessVector;
    }

    public void setAccessVector(AccessVectorType accessVector) {
        this.accessVector = accessVector;
    }

    public AccessComplexityType getAccessComplexity() {
        return this.accessComplexity;
    }

    public void setAccessComplexity(AccessComplexityType accessComplexity) {
        this.accessComplexity = accessComplexity;
    }

    public AuthenticationType getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
    }

    public CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    public void setConfidentialityImpact(CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    public void setIntegrityImpact(CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    public void setAvailabilityImpact(CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    public Double getBaseScore() {
        return this.baseScore;
    }

    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    public ExploitabilityType getExploitability() {
        return this.exploitability;
    }

    public void setExploitability(ExploitabilityType exploitability) {
        this.exploitability = exploitability;
    }

    public RemediationLevelType getRemediationLevel() {
        return this.remediationLevel;
    }

    public void setRemediationLevel(RemediationLevelType remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public ReportConfidenceType getReportConfidence() {
        return this.reportConfidence;
    }

    public void setReportConfidence(ReportConfidenceType reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public Double getTemporalScore() {
        return this.temporalScore;
    }

    public void setTemporalScore(Double temporalScore) {
        this.temporalScore = temporalScore;
    }

    public CollateralDamagePotentialType getCollateralDamagePotential() {
        return this.collateralDamagePotential;
    }

    public void setCollateralDamagePotential(CollateralDamagePotentialType collateralDamagePotential) {
        this.collateralDamagePotential = collateralDamagePotential;
    }

    public TargetDistributionType getTargetDistribution() {
        return this.targetDistribution;
    }

    public void setTargetDistribution(TargetDistributionType targetDistribution) {
        this.targetDistribution = targetDistribution;
    }

    public CiaRequirementType getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    public void setConfidentialityRequirement(CiaRequirementType confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public CiaRequirementType getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    public void setIntegrityRequirement(CiaRequirementType integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public CiaRequirementType getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    public void setAvailabilityRequirement(CiaRequirementType availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public Double getEnvironmentalScore() {
        return this.environmentalScore;
    }

    public void setEnvironmentalScore(Double environmentalScore) {
        this.environmentalScore = environmentalScore;
    }

    public static enum AccessComplexityType {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, AccessComplexityType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, AccessComplexityType>();
            AccessComplexityType[] accessComplexityTypeArray = AccessComplexityType.values();
            int n = accessComplexityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessComplexityType c = accessComplexityTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private AccessComplexityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static AccessComplexityType fromValue(String value) {
            AccessComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum AccessVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL");

        private final String value;
        private static final Map<String, AccessVectorType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, AccessVectorType>();
            AccessVectorType[] accessVectorTypeArray = AccessVectorType.values();
            int n = accessVectorTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessVectorType c = accessVectorTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private AccessVectorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static AccessVectorType fromValue(String value) {
            AccessVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum AuthenticationType {
        MULTIPLE("MULTIPLE"),
        SINGLE("SINGLE"),
        NONE("NONE");

        private final String value;
        private static final Map<String, AuthenticationType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, AuthenticationType>();
            AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
            int n = authenticationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AuthenticationType c = authenticationTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private AuthenticationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static AuthenticationType fromValue(String value) {
            AuthenticationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum CiaRequirementType {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private final String value;
        private static final Map<String, CiaRequirementType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, CiaRequirementType>();
            CiaRequirementType[] ciaRequirementTypeArray = CiaRequirementType.values();
            int n = ciaRequirementTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CiaRequirementType c = ciaRequirementTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private CiaRequirementType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CiaRequirementType fromValue(String value) {
            CiaRequirementType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        PARTIAL("PARTIAL"),
        COMPLETE("COMPLETE");

        private final String value;
        private static final Map<String, CiaType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            CiaType[] ciaTypeArray = CiaType.values();
            int n = ciaTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CiaType c = ciaTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private CiaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CiaType fromValue(String value) {
            CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum CollateralDamagePotentialType {
        NONE("NONE"),
        LOW("LOW"),
        LOW_MEDIUM("LOW_MEDIUM"),
        MEDIUM_HIGH("MEDIUM_HIGH"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private final String value;
        private static final Map<String, CollateralDamagePotentialType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, CollateralDamagePotentialType>();
            CollateralDamagePotentialType[] collateralDamagePotentialTypeArray = CollateralDamagePotentialType.values();
            int n = collateralDamagePotentialTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollateralDamagePotentialType c = collateralDamagePotentialTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private CollateralDamagePotentialType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CollateralDamagePotentialType fromValue(String value) {
            CollateralDamagePotentialType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum ExploitabilityType {
        UNPROVEN("UNPROVEN"),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        FUNCTIONAL("FUNCTIONAL"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private final String value;
        private static final Map<String, ExploitabilityType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, ExploitabilityType>();
            ExploitabilityType[] exploitabilityTypeArray = ExploitabilityType.values();
            int n = exploitabilityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExploitabilityType c = exploitabilityTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private ExploitabilityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static ExploitabilityType fromValue(String value) {
            ExploitabilityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum RemediationLevelType {
        OFFICIAL_FIX("OFFICIAL_FIX"),
        TEMPORARY_FIX("TEMPORARY_FIX"),
        WORKAROUND("WORKAROUND"),
        UNAVAILABLE("UNAVAILABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private final String value;
        private static final Map<String, RemediationLevelType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, RemediationLevelType>();
            RemediationLevelType[] remediationLevelTypeArray = RemediationLevelType.values();
            int n = remediationLevelTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RemediationLevelType c = remediationLevelTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private RemediationLevelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static RemediationLevelType fromValue(String value) {
            RemediationLevelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum ReportConfidenceType {
        UNCONFIRMED("UNCONFIRMED"),
        UNCORROBORATED("UNCORROBORATED"),
        CONFIRMED("CONFIRMED"),
        NOT_DEFINED("NOT_DEFINED");

        private final String value;
        private static final Map<String, ReportConfidenceType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, ReportConfidenceType>();
            ReportConfidenceType[] reportConfidenceTypeArray = ReportConfidenceType.values();
            int n = reportConfidenceTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportConfidenceType c = reportConfidenceTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private ReportConfidenceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static ReportConfidenceType fromValue(String value) {
            ReportConfidenceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum TargetDistributionType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private final String value;
        private static final Map<String, TargetDistributionType> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, TargetDistributionType>();
            TargetDistributionType[] targetDistributionTypeArray = TargetDistributionType.values();
            int n = targetDistributionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetDistributionType c = targetDistributionTypeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private TargetDistributionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static TargetDistributionType fromValue(String value) {
            TargetDistributionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }

    public static enum Version {
        _2_0("2.0");

        private final String value;
        private static final Map<String, Version> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, Version>();
            Version[] versionArray = Version.values();
            int n = versionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Version c = versionArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private Version(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }
}

