/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.vulnerability.core.nvd;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.palladiosimulator.retriever.vulnerability.core.nvd.CpeMatch;

public class Node {
    @SerializedName(value="operator")
    @Expose
    private Operator operator;
    @SerializedName(value="negate")
    @Expose
    private Boolean negate;
    @SerializedName(value="cpeMatch")
    @Expose
    private List<CpeMatch> cpeMatch;

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Boolean getNegate() {
        return this.negate;
    }

    public void setNegate(Boolean negate) {
        this.negate = negate;
    }

    public List<CpeMatch> getCpeMatch() {
        return this.cpeMatch;
    }

    public void setCpeMatch(List<CpeMatch> cpeMatch) {
        this.cpeMatch = cpeMatch;
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private final String value;
        private static final Map<String, Operator> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, Operator>();
            Operator[] operatorArray = Operator.values();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator c = operatorArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }
}

