/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.core.filters;

import javax.measure.Measurable;
import javax.measure.Measure;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.datastream.filter.AbstractFilter;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.edp2.core.filters.SLOViolationEDP2DatasourceFilterConfiguration;

public class SLOViolationEDP2DatasourceFilter
extends AbstractFilter {
    public SLOViolationEDP2DatasourceFilter() {
        super((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE);
    }

    public SLOViolationEDP2DatasourceFilter(IDataSource datasource) {
        super(datasource, (MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE);
    }

    public SLOViolationEDP2DatasourceFilter(IDataSource datasource, MetricDescription metricDescription) {
        super(datasource, metricDescription);
    }

    protected boolean shouldSkip(MeasuringValue measurement) {
        Measure upperThreshold;
        Measure lowerThreshold;
        if (this.getConfiguration().isPropertyNotSet("serviceLevelObjective")) {
            return false;
        }
        Object propertyObject = this.getConfiguration().getProperties().get("serviceLevelObjective");
        if (!(propertyObject instanceof ServiceLevelObjective)) {
            return false;
        }
        ServiceLevelObjective serviceLevelObjective = (ServiceLevelObjective)propertyObject;
        Measure responseTime = measurement.getMeasureForMetric(serviceLevelObjective.getMeasurementSpecification().getMetricDescription());
        if (serviceLevelObjective.getLowerThreshold() != null && responseTime.compareTo((Measurable)(lowerThreshold = serviceLevelObjective.getLowerThreshold().getThresholdLimit())) < 0) {
            return false;
        }
        return serviceLevelObjective.getUpperThreshold() == null || responseTime.compareTo((Measurable)(upperThreshold = serviceLevelObjective.getUpperThreshold().getThresholdLimit())) <= 0;
    }

    protected PropertyConfigurable createProperties() {
        return new SLOViolationEDP2DatasourceFilterConfiguration();
    }
}

