/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.mappers;

import java.util.HashMap;
import javax.measure.Measurable;
import javax.measure.Measure;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableElement;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.datastream.filter.AbstractFilter;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.NegativeQuadraticFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.QuadraticFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.SoftThreshold;
import org.palladiosimulator.servicelevelobjective.Threshold;
import org.palladiosimulator.servicelevelobjective.edp2.mappers.SLOViolationEDP2DatasourceMapperConfiguration;

public class SLOViolationEDP2DatasourceMapper
extends AbstractFilter
implements IPersistable,
IPersistableElement {
    HashMap<Measure, Double> map = new HashMap();
    double toAdd;

    public SLOViolationEDP2DatasourceMapper() {
        super((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE);
    }

    public SLOViolationEDP2DatasourceMapper(IDataSource datasource) {
        super(datasource, (MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE);
    }

    public SLOViolationEDP2DatasourceMapper(IDataSource datasource, MetricDescription metricDescription) {
        super(datasource, metricDescription);
    }

    protected boolean shouldSkip(MeasuringValue measurement) {
        if (this.getConfiguration().isPropertyNotSet("serviceLevelObjective")) {
            return false;
        }
        Object propertyObject = this.getConfiguration().getProperties().get("serviceLevelObjective");
        if (!(propertyObject instanceof ServiceLevelObjective)) {
            return false;
        }
        ServiceLevelObjective serviceLevelObjective = (ServiceLevelObjective)propertyObject;
        Measure responseTime = measurement.getMeasureForMetric(serviceLevelObjective.getMeasurementSpecification().getMetricDescription());
        Threshold lowerThreshold = serviceLevelObjective.getLowerThreshold();
        Threshold upperThreshold = serviceLevelObjective.getUpperThreshold();
        this.toAdd = this.getGrade(responseTime, lowerThreshold, upperThreshold);
        this.map.put(responseTime, this.toAdd);
        return false;
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
    }

    private double getGrade(Measure measurement, Threshold lower, Threshold upper) {
        if (lower != null) {
            Measure lowerThresholdSoftLimit;
            Measure lowerThresholdHardLimit = lower.getThresholdLimit();
            if (measurement.compareTo((Measurable)lowerThresholdHardLimit) < 0) {
                return 0.0;
            }
            if (lower instanceof SoftThreshold && measurement.compareTo((Measurable)(lowerThresholdSoftLimit = ((SoftThreshold)lower).getSoftLimit())) < 0) {
                return this.gradeSoftLowerThreshold(measurement, (SoftThreshold)lower);
            }
        }
        if (upper != null) {
            Measure upperThresholdHardLimit = upper.getThresholdLimit();
            if (upper instanceof SoftThreshold) {
                Measure upperThresholdSoftLimit = ((SoftThreshold)upper).getSoftLimit();
                if (measurement.compareTo((Measurable)upperThresholdSoftLimit) <= 0) {
                    return 1.0;
                }
                if (measurement.compareTo((Measurable)upperThresholdHardLimit) <= 0) {
                    return this.gradeSoftUpperThreshold(measurement, (SoftThreshold)upper);
                }
            } else if (measurement.compareTo((Measurable)upperThresholdHardLimit) <= 0) {
                return 1.0;
            }
        } else {
            return 1.0;
        }
        return 0.0;
    }

    private double gradeSoftLowerThreshold(Measure toGrade, SoftThreshold lowerThreshold) {
        double x = (Double)toGrade.getValue();
        double soft = lowerThreshold.getSoftLimit().doubleValue(toGrade.getUnit());
        double hard = lowerThreshold.getThresholdLimit().doubleValue(toGrade.getUnit());
        if (lowerThreshold instanceof LinearFuzzyThreshold) {
            return 1.0 / (soft - hard) * (x - hard);
        }
        if (lowerThreshold instanceof QuadraticFuzzyThreshold) {
            return 1.0 / Math.pow(soft - hard, 2.0) * Math.pow(x - hard, 2.0);
        }
        if (lowerThreshold instanceof NegativeQuadraticFuzzyThreshold) {
            return 1.0 - 1.0 / Math.pow(soft - hard, 2.0) * Math.pow(x - soft, 2.0);
        }
        return 0.0;
    }

    private double gradeSoftUpperThreshold(Measure toGrade, SoftThreshold upperThreshold) {
        double x = (Double)toGrade.getValue();
        double soft = upperThreshold.getSoftLimit().doubleValue(toGrade.getUnit());
        double hard = upperThreshold.getThresholdLimit().doubleValue(toGrade.getUnit());
        if (upperThreshold instanceof LinearFuzzyThreshold) {
            return -1.0 / (hard - soft) * (x - hard);
        }
        if (upperThreshold instanceof QuadraticFuzzyThreshold) {
            return 1.0 / Math.pow(hard - soft, 2.0) * Math.pow(x - hard, 2.0);
        }
        if (upperThreshold instanceof NegativeQuadraticFuzzyThreshold) {
            return 1.0 - 1.0 / Math.pow(hard - soft, 2.0) * Math.pow(x - soft, 2.0);
        }
        return 0.0;
    }

    protected PropertyConfigurable createProperties() {
        return new SLOViolationEDP2DatasourceMapperConfiguration();
    }

    public HashMap<Measure, Double> getMapping() {
        IDataStream stream = super.getDataStream();
        stream.size();
        stream.close();
        return this.map;
    }
}

