/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulation.abstractsimengine.ssj;

import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractExperiment;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import org.palladiosimulator.simulation.abstractsimengine.ssj.SSJModel;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.Simulator;
import umontreal.ssj.simevents.eventlist.EventList;
import umontreal.ssj.simevents.eventlist.SplayTree;

public class SSJExperiment
extends AbstractExperiment {
    private final Simulator simulator = new Simulator();
    private Event maxSimTimeTrigger;

    public SSJExperiment(SSJModel model) {
        super((ISimulationModel)model);
        this.simulator.init((EventList)new SplayTree());
    }

    public double getCurrentSimulationTime() {
        return this.simulator.time();
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public void startSimulator() {
        this.simulator.start();
    }

    public void stopSimulator() {
        this.simulator.stop();
    }

    public void setMaxSimTime(long simTime) {
        if (this.maxSimTimeTrigger != null) {
            this.maxSimTimeTrigger.cancel();
        }
        this.maxSimTimeTrigger = new Event(this.simulator){

            public void actions() {
                SSJExperiment.this.simulator.stop();
            }
        };
        this.maxSimTimeTrigger.schedule((double)simTime - (this.simulator.isSimulating() ? this.simulator.time() : 0.0));
    }
}

