/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.repository.black;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.modelversioning.emfprofile.Profile;
import org.palladiosimulator.mdsdprofiles.api.ProfileAPI;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.NamedElement;

public class ProfilesLibrary {
    @Operation(kind=Operation.Kind.QUERY, contextual=true)
    public static boolean hasAppliedStereotype(Entity pcmEntity, String stereotypeName) {
        return StereotypeAPI.isStereotypeApplied((EObject)pcmEntity, (String)stereotypeName);
    }

    public static boolean hasAppliedStereotype(Set<Entity> pcmEntitySet, String stereotypeName) {
        return StereotypeAPI.hasAppliedStereotype(pcmEntitySet, (String)stereotypeName);
    }

    @Operation(kind=Operation.Kind.QUERY, contextual=true)
    public static boolean hasAppliedStereotype(Identifier pcmIdentifier, String stereotypeName) {
        return StereotypeAPI.isStereotypeApplied((EObject)pcmIdentifier, (String)stereotypeName);
    }

    public static boolean appliedStereotypesEqualsOne(Set<Entity> pcmEntitySet, String stereotypeName) {
        return pcmEntitySet.stream().filter(e -> StereotypeAPI.isStereotypeApplied((EObject)e, (String)stereotypeName)).count() == 1L;
    }

    private static Optional<Profile> queryProfileByStereotypeName(Identifier pcmIdentifier, String stereotypeName) {
        assert (stereotypeName != null && pcmIdentifier != null);
        return ProfileAPI.getApplicableProfiles().stream().filter(profile -> profile.getStereotype(stereotypeName) != null).findAny();
    }

    private static void ensureProfileApplied(Resource resource, Profile profile) {
        assert (resource != null && profile != null);
        if (!ProfileAPI.isProfileApplied((Resource)resource, (Profile)profile)) {
            ProfileAPI.applyProfile((Resource)resource, (Profile)profile);
        }
    }

    private static void ensureProfileApplied(Identifier pcmIdentifier, String stereotypeName) {
        assert (pcmIdentifier != null && stereotypeName != null);
        Profile profile = ProfilesLibrary.queryProfileByStereotypeName(pcmIdentifier, stereotypeName).orElseThrow(() -> new IllegalArgumentException("Stereotype with given name '" + stereotypeName + "' does not exist!"));
        ProfilesLibrary.ensureProfileApplied(pcmIdentifier.eResource(), profile);
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true)
    public static void applyStereotype(Entity pcmEntity, String stereotypeName) {
        ProfilesLibrary.ensureProfileApplied((Identifier)pcmEntity, stereotypeName);
        StereotypeAPI.applyStereotype((EObject)pcmEntity, (String)stereotypeName);
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true)
    public static void applyStereotype(Identifier pcmIdentifier, String stereotypeName) {
        ProfilesLibrary.ensureProfileApplied(pcmIdentifier, stereotypeName);
        StereotypeAPI.applyStereotype((EObject)pcmIdentifier, (String)stereotypeName);
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true)
    public static void removeStereotypeApplications(Entity pcmEntity, String stereotypeName) {
        ProfilesLibrary.ensureProfileApplied((Identifier)pcmEntity, stereotypeName);
        if (StereotypeAPI.isStereotypeApplied((EObject)pcmEntity, (String)stereotypeName)) {
            StereotypeAPI.unapplyStereotype((EObject)pcmEntity, (String)stereotypeName);
        }
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true)
    public static void removeStereotypeApplications(Identifier pcmIdentifier, String stereotypeName) {
        ProfilesLibrary.ensureProfileApplied(pcmIdentifier, stereotypeName);
        if (StereotypeAPI.isStereotypeApplied((EObject)pcmIdentifier, (String)stereotypeName)) {
            StereotypeAPI.unapplyStereotype((EObject)pcmIdentifier, (String)stereotypeName);
        }
    }

    public static void setTaggedValue(Entity pcmEntity, int value, String stereotypeName, String taggedValueName) {
        StereotypeAPI.setTaggedValue((EObject)pcmEntity, (Object)value, (String)stereotypeName, (String)taggedValueName);
    }

    public static int getIntTaggedValue(Entity pcmEntity, String taggedValueName, String stereotypeName) {
        return (Integer)StereotypeAPI.getTaggedValue((EObject)pcmEntity, (String)taggedValueName, (String)stereotypeName);
    }

    public static double getDoubleTaggedValue(Entity pcmEntity, String taggedValueName, String stereotypeName) {
        return (Double)StereotypeAPI.getTaggedValue((EObject)pcmEntity, (String)taggedValueName, (String)stereotypeName);
    }

    public static void delete(List<NamedElement> rootEObjects, Entity eObject) {
        HashSet<Object> eObjects = new HashSet<Object>();
        HashSet<InternalEObject> crossResourceEObjects = new HashSet<InternalEObject>();
        eObjects.add(eObject);
        TreeIterator j = eObject.eAllContents();
        while (j.hasNext()) {
            InternalEObject internalEObject = (InternalEObject)j.next();
            if (internalEObject.eDirectResource() != null) {
                crossResourceEObjects.add(internalEObject);
                continue;
            }
            eObjects.add(internalEObject);
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll(eObjects, rootEObjects);
        for (Map.Entry entry : usages.entrySet()) {
            EObject deletedEObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                if (eObjects.contains(setting.getEObject()) || !setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)deletedEObject);
            }
        }
        EcoreUtil.remove((EObject)eObject);
        for (EObject eObject2 : crossResourceEObjects) {
            EcoreUtil.remove((EObject)eObject2.eContainer(), (EStructuralFeature)eObject2.eContainmentFeature(), (Object)eObject2);
        }
    }
}

