/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.interpreter;

import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.palladiosimulator.simulizar.action.context.ExecutionContext;

public final class ExecutionContextKeeper {
    private static final ExecutionContextKeeper instance = new ExecutionContextKeeper();
    private final Map<String, SimuComSimProcess> contextProcessMapping = new ConcurrentHashMap<String, SimuComSimProcess>();

    private ExecutionContextKeeper() {
    }

    public static ExecutionContextKeeper getInstance() {
        return instance;
    }

    void addContextProcessMapping(ExecutionContext context, SimuComSimProcess process) {
        String key = this.computeKey(Objects.requireNonNull(context));
        if (this.contextProcessMapping.containsKey(key)) {
            throw new IllegalArgumentException("Given ExecutionContext " + context.getId() + " is already " + "associated with a SimuComSmProcess!");
        }
        this.contextProcessMapping.put(this.computeKey(Objects.requireNonNull(context)), Objects.requireNonNull(process));
    }

    void removeContextProcessMapping(ExecutionContext context, SimuComSimProcess process) {
        this.contextProcessMapping.remove(this.computeKey(Objects.requireNonNull(context)), Objects.requireNonNull(process));
    }

    public Optional<SimuComSimProcess> getProcessForContext(ExecutionContext context) {
        return Optional.ofNullable(this.contextProcessMapping.get(this.computeKey(Objects.requireNonNull(context, "Context to lookup must not be null."))));
    }

    private String computeKey(ExecutionContext context) {
        assert (context != null);
        return context.getId();
    }
}

