/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulizar.aggregation.aggregators;

import java.util.Objects;
import java.util.Optional;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementDrivenAggregation;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.statisticalcharacterization.StatisticalCharacterizationAggregator;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.metrics.PRMRecorder;

public abstract class AbstractMeasurementAggregator
extends PRMRecorder
implements IMeasurementSourceListener {
    private final StatisticalCharacterizationAggregator aggregator;
    private final NumericalBaseMetricDescription expectedMetric;
    private final int frequencyOfAggregation;
    private int measurementsUntilNextAggregation = 0;

    AbstractMeasurementAggregator(NumericalBaseMetricDescription expectedMetric, RuntimeMeasurementModel prmAccess, MeasurementDrivenAggregation measurementDrivenAggregation) {
        super(prmAccess, Objects.requireNonNull(measurementDrivenAggregation).getMeasurementSpecification());
        this.expectedMetric = Objects.requireNonNull(expectedMetric);
        this.aggregator = measurementDrivenAggregation.getStatisticalCharacterization().getAggregator(expectedMetric);
        this.frequencyOfAggregation = measurementDrivenAggregation.getFrequency();
        if (this.frequencyOfAggregation < 1) {
            throw new IllegalStateException("Value of '" + MonitorRepositoryPackage.Literals.MEASUREMENT_DRIVEN_AGGREGATION__FREQUENCY.getName() + "' attribute of '" + measurementDrivenAggregation.eClass().getName() + "' with id " + measurementDrivenAggregation.getId() + " must be positive!");
        }
        this.resetCounter();
    }

    protected final void resetCounter() {
        this.measurementsUntilNextAggregation = this.frequencyOfAggregation;
    }

    protected final void decrementCounter() {
        assert (this.measurementsUntilNextAggregation > 0);
        --this.measurementsUntilNextAggregation;
    }

    public final void newMeasurementAvailable(MeasuringValue newMeasurement) {
        if (!Objects.requireNonNull(newMeasurement).isCompatibleWith((MetricDescription)this.expectedMetric) && !MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)this.expectedMetric, (MetricDescription)newMeasurement.getMetricDesciption())) {
            throw new IllegalStateException("Somehow a wrong measurement kind was passed.");
        }
        this.collectMeasurement(newMeasurement);
        this.decrementCounter();
        if (this.measurementsUntilNextAggregation == 0) {
            if (this.aggregationRequired()) {
                this.onPreAggregate();
                this.aggregate();
                this.onPostAggregate();
            }
            this.resetCounter();
        }
    }

    public void preUnregister() {
        super.detachFromPRM();
        this.clear();
    }

    public abstract void clear();

    protected abstract boolean aggregationRequired();

    protected abstract Amount<Duration> getIntervalStartTime();

    protected abstract Amount<Duration> getIntervalEndTime();

    protected abstract Iterable<MeasuringValue> getDataToAggregate();

    protected abstract void collectMeasurement(MeasuringValue var1);

    protected void onPreAggregate() {
    }

    protected void onPostAggregate() {
    }

    protected final NumericalBaseMetricDescription getExpectedMetric() {
        return this.expectedMetric;
    }

    protected static Amount<Duration> getPointInTimeOfMeasurement(MeasuringValue measurement) {
        assert (measurement != null);
        Measure pointInTimeMeasure = measurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        return Amount.valueOf((double)((Double)pointInTimeMeasure.getValue()), (Unit)pointInTimeMeasure.getUnit());
    }

    private void aggregate() {
        MeasuringValue aggregatedData = this.aggregator.aggregateData(this.getDataToAggregate(), this.getIntervalStartTime(), this.getIntervalEndTime(), Optional.empty());
        super.updateMeasurementValue(aggregatedData.getMeasureForMetric((MetricDescription)this.expectedMetric).doubleValue(this.expectedMetric.getDefaultUnit()));
    }
}

