/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulizar.aggregation.aggregators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import javax.measure.quantity.Duration;
import org.apache.commons.collections15.IteratorUtils;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.FixedSizeAggregation;
import org.palladiosimulator.monitorrepository.MeasurementDrivenAggregation;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulizar.aggregation.aggregators.AbstractMeasurementAggregator;

public class FixedSizeMeasurementsAggregator
extends AbstractMeasurementAggregator {
    private final InternalBuffer buffer;

    public FixedSizeMeasurementsAggregator(NumericalBaseMetricDescription expectedMetric, RuntimeMeasurementModel runtimeMeasurementModel, FixedSizeAggregation fixedSizeAggregation) {
        super(Objects.requireNonNull(expectedMetric), Objects.requireNonNull(runtimeMeasurementModel), (MeasurementDrivenAggregation)Objects.requireNonNull(fixedSizeAggregation));
        this.buffer = new InternalBuffer(FixedSizeMeasurementsAggregator.checkAndGetNumberOfMeasurementsAttribute(fixedSizeAggregation));
    }

    private static int checkAndGetNumberOfMeasurementsAttribute(FixedSizeAggregation fixedSizeAggregation) {
        int numMeas = fixedSizeAggregation.getNumberOfMeasurements();
        if (numMeas < 1) {
            throw new IllegalStateException("Value of '" + MonitorRepositoryPackage.Literals.FIXED_SIZE_AGGREGATION__NUMBER_OF_MEASUREMENTS.getName() + "' attribute of " + "'" + fixedSizeAggregation.eClass().getName() + "' with id " + fixedSizeAggregation.getId() + " must be positive!");
        }
        return numMeas;
    }

    @Override
    protected void collectMeasurement(MeasuringValue newMeasurement) {
        this.buffer.add(newMeasurement);
    }

    @Override
    protected boolean aggregationRequired() {
        return this.buffer.isFull();
    }

    @Override
    protected Amount<Duration> getIntervalStartTime() {
        return FixedSizeMeasurementsAggregator.getPointInTimeOfMeasurement(this.buffer.getEldestElement());
    }

    @Override
    protected Amount<Duration> getIntervalEndTime() {
        return FixedSizeMeasurementsAggregator.getPointInTimeOfMeasurement(this.buffer.getNewestElement());
    }

    @Override
    protected Iterable<MeasuringValue> getDataToAggregate() {
        return this.buffer;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    private static final class InternalBuffer
    implements Iterable<MeasuringValue> {
        private final MeasuringValue[] data;
        private int eldestElementPointer = 0;
        private int currentElementCount = 0;

        private InternalBuffer(int capacity) {
            assert (capacity > 0);
            this.data = new MeasuringValue[capacity];
        }

        public int size() {
            return this.currentElementCount;
        }

        public int capacity() {
            return this.data.length;
        }

        public boolean isFull() {
            return this.size() == this.capacity();
        }

        public boolean add(MeasuringValue measuringValue) {
            if (this.isFull()) {
                this.addFull(measuringValue);
            } else {
                this.addNotFull(measuringValue);
            }
            return true;
        }

        public MeasuringValue getEldestElement() {
            return this.data[this.eldestElementPointer];
        }

        private void addFull(MeasuringValue newElemement) {
            assert (this.isFull() && newElemement != null);
            this.data[this.eldestElementPointer] = newElemement;
            ++this.eldestElementPointer;
            this.eldestElementPointer %= this.capacity();
            assert (this.eldestElementPointer >= 0 && this.eldestElementPointer < this.capacity());
        }

        private void addNotFull(MeasuringValue elementToAdd) {
            assert (!this.isFull() && elementToAdd != null);
            this.data[this.currentElementCount++] = elementToAdd;
        }

        public void clear() {
            Arrays.fill(this.data, null);
            this.currentElementCount = 0;
            this.eldestElementPointer = 0;
        }

        public MeasuringValue getNewestElement() {
            return this.data[(this.eldestElementPointer + this.size() - 1) % this.capacity()];
        }

        @Override
        public Iterator<MeasuringValue> iterator() {
            return IteratorUtils.unmodifiableIterator((Iterator)IteratorUtils.arrayIterator((Object[])this.data));
        }
    }
}

