package org.palladiosimulator.simulizar.di.component.dependency;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.ISimulatedModelEntityAccess;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.simulizar.core.runtimestate.SimuComModelFactory;
import org.palladiosimulator.simulizar.core.runtimestate.SimuComModelFactory_Factory;
import org.palladiosimulator.simulizar.di.modules.scoped.dependency.DefaultSimuComFrameworkBindings_BindRCAccessFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.dependency.DefaultSimuComFrameworkBindings_ProvideRandomGeneratorFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.dependency.DefaultSimuComFrameworkBindings_ProvideResourceRegistryFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.dependency.DefaultSimuComFrameworkBindings_ProvideResourceTableManagerFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.dependency.DefaultSimuComFrameworkBindings_ProvideSimuComModelFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.dependency.DefaultSimuComFrameworkBindings_ProvideSimulationControlFactory;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerSimuComFrameworkComponent implements SimuComFrameworkComponent {
  private Provider<SimuComConfig> simuComConfigProvider;

  private Provider<IResourceTableManager> provideResourceTableManagerProvider;

  private Provider<ISimEngineFactory> simEngineFactoryProvider;

  private Provider<ProbeFrameworkContext> probeFrameworkContextProvider;

  private Provider<SimuComModelFactory> simuComModelFactoryProvider;

  private Provider<SimuComModel> provideSimuComModelProvider;

  private Provider<ISimulationControl> provideSimulationControlProvider;

  private Provider<ResourceRegistry> provideResourceRegistryProvider;

  private Provider<IRandomGenerator> provideRandomGeneratorProvider;

  private DaggerSimuComFrameworkComponent(SimEngineComponent simEngineComponentParam,
      QUALComponent qUALComponentParam, SimuComConfig simuComConfigParam) {

    initialize(simEngineComponentParam, qUALComponentParam, simuComConfigParam);
  }

  public static SimuComFrameworkComponent.Factory factory() {
    return new Factory();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final SimEngineComponent simEngineComponentParam,
      final QUALComponent qUALComponentParam, final SimuComConfig simuComConfigParam) {
    this.simuComConfigProvider = InstanceFactory.create(simuComConfigParam);
    this.provideResourceTableManagerProvider = DoubleCheck.provider(DefaultSimuComFrameworkBindings_ProvideResourceTableManagerFactory.create());
    this.simEngineFactoryProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimEngineComponent_simEngineFactory(simEngineComponentParam);
    this.probeFrameworkContextProvider = new org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_probeFrameworkContext(qUALComponentParam);
    this.simuComModelFactoryProvider = SimuComModelFactory_Factory.create(simuComConfigProvider, provideResourceTableManagerProvider, simEngineFactoryProvider, probeFrameworkContextProvider);
    this.provideSimuComModelProvider = DoubleCheck.provider(DefaultSimuComFrameworkBindings_ProvideSimuComModelFactory.create(simuComModelFactoryProvider));
    this.provideSimulationControlProvider = DoubleCheck.provider(DefaultSimuComFrameworkBindings_ProvideSimulationControlFactory.create(provideSimuComModelProvider));
    this.provideResourceRegistryProvider = DoubleCheck.provider(DefaultSimuComFrameworkBindings_ProvideResourceRegistryFactory.create(provideSimuComModelProvider));
    this.provideRandomGeneratorProvider = DoubleCheck.provider(DefaultSimuComFrameworkBindings_ProvideRandomGeneratorFactory.create(provideSimuComModelProvider));
  }

  @Override
  public SimuComModel simuComModel() {
    return provideSimuComModelProvider.get();
  }

  @Override
  public ISimulationControl simulationControl() {
    return provideSimulationControlProvider.get();
  }

  @Override
  public IResourceTableManager resourceTableManager() {
    return provideResourceTableManagerProvider.get();
  }

  @Override
  public ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer> resourceContainerAccess(
      ) {
    return DefaultSimuComFrameworkBindings_BindRCAccessFactory.bindRCAccess(provideResourceRegistryProvider.get());
  }

  @Override
  public ResourceRegistry resourceRegistry() {
    return provideResourceRegistryProvider.get();
  }

  @Override
  public ISimulationTimeProvider simTimeProvider() {
    return provideSimulationControlProvider.get();
  }

  @Override
  public IRandomGenerator randomGenerator() {
    return provideRandomGeneratorProvider.get();
  }

  private static final class Factory implements SimuComFrameworkComponent.Factory {
    @Override
    public SimuComFrameworkComponent create(SimuComConfig simuComConfig,
        SimEngineComponent simEngineComponent, QUALComponent qualComponent) {
      Preconditions.checkNotNull(simuComConfig);
      Preconditions.checkNotNull(simEngineComponent);
      Preconditions.checkNotNull(qualComponent);
      return new DaggerSimuComFrameworkComponent(simEngineComponent, qualComponent, simuComConfig);
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimEngineComponent_simEngineFactory implements Provider<ISimEngineFactory> {
    private final SimEngineComponent simEngineComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimEngineComponent_simEngineFactory(
        SimEngineComponent simEngineComponent) {
      this.simEngineComponent = simEngineComponent;
    }

    @Override
    public ISimEngineFactory get() {
      return Preconditions.checkNotNullFromComponent(simEngineComponent.simEngineFactory());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_probeFrameworkContext implements Provider<ProbeFrameworkContext> {
    private final QUALComponent qUALComponent;

    org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_probeFrameworkContext(
        QUALComponent qUALComponent) {
      this.qUALComponent = qUALComponent;
    }

    @Override
    public ProbeFrameworkContext get() {
      return Preconditions.checkNotNullFromComponent(qUALComponent.probeFrameworkContext());
    }
  }
}
