package org.palladiosimulator.simulizar.di.component.dependency;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import de.uka.ipd.sdq.simulation.core.AbstractSimulationConfig;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfigurationFactory;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.di.modules.component.core.QUALModule_BindObservableCalculatorRegistryFactory;
import org.palladiosimulator.simulizar.di.modules.component.core.QUALModule_ProvideProbeframeworkContextFactory;
import org.palladiosimulator.simulizar.di.modules.component.eclipse.EclipseQUALModule_ProvideCalculatorFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.component.eclipse.EclipseQUALModule_ProvideRecorderConfigurationFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.configuration.SimuLizarConfigurationModule_ProvideSimConfigFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.configuration.SimulationConfigBindingModule_ProvideRecorderNameFactory;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerQUALComponent implements QUALComponent {
  private Provider<SimuLizarWorkflowConfiguration> simConfigProvider;

  private Provider<AbstractSimulationConfig> provideSimConfigProvider;

  private Provider<String> provideRecorderNameProvider;

  private Provider<IRecorderConfigurationFactory> provideRecorderConfigurationFactoryProvider;

  private Provider<IGenericCalculatorFactory> provideCalculatorFactoryProvider;

  private Provider<ProbeFrameworkContext> provideProbeframeworkContextProvider;

  private DaggerQUALComponent(SimuLizarWorkflowConfiguration simConfigParam) {

    initialize(simConfigParam);
  }

  public static QUALComponent.Factory factory() {
    return new Factory();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final SimuLizarWorkflowConfiguration simConfigParam) {
    this.simConfigProvider = InstanceFactory.create(simConfigParam);
    this.provideSimConfigProvider = SimuLizarConfigurationModule_ProvideSimConfigFactory.create(simConfigProvider);
    this.provideRecorderNameProvider = SimulationConfigBindingModule_ProvideRecorderNameFactory.create(provideSimConfigProvider);
    this.provideRecorderConfigurationFactoryProvider = DoubleCheck.provider(EclipseQUALModule_ProvideRecorderConfigurationFactoryFactory.create(provideRecorderNameProvider));
    this.provideCalculatorFactoryProvider = DoubleCheck.provider(EclipseQUALModule_ProvideCalculatorFactoryFactory.create(provideRecorderNameProvider, provideRecorderConfigurationFactoryProvider));
    this.provideProbeframeworkContextProvider = DoubleCheck.provider(QUALModule_ProvideProbeframeworkContextFactory.create(provideCalculatorFactoryProvider));
  }

  @Override
  public IGenericCalculatorFactory calculatorFactory() {
    return provideCalculatorFactoryProvider.get();
  }

  @Override
  public IObservableCalculatorRegistry calculatorRegistry() {
    return QUALModule_BindObservableCalculatorRegistryFactory.bindObservableCalculatorRegistry(provideProbeframeworkContextProvider.get());
  }

  @Override
  public ProbeFrameworkContext probeFrameworkContext() {
    return provideProbeframeworkContextProvider.get();
  }

  @Override
  public IRecorderConfigurationFactory recorderConfigurationFactory() {
    return provideRecorderConfigurationFactoryProvider.get();
  }

  private static final class Factory implements QUALComponent.Factory {
    @Override
    public QUALComponent create(SimuLizarWorkflowConfiguration simConfig) {
      Preconditions.checkNotNull(simConfig);
      return new DaggerQUALComponent(simConfig);
    }
  }
}
