/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.measuringpoint.create;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.palladiosimulator.simulizar.measuringpoint.create.StereotypeApplicationListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceURIsFromMPsExtractor
implements IResourceVisitor {
    private List<String> existingMPs;
    private Map<String, IResource> existingSAs;

    public ResourceURIsFromMPsExtractor(List<String> existingMPs, Map<String, IResource> existingSAs) {
        this.existingMPs = existingMPs;
        this.existingSAs = existingSAs;
    }

    public boolean visit(IResource resource) throws CoreException {
        try {
            if (resource.getFullPath().toString().endsWith(".measuringpoint")) {
                Document doc = StereotypeApplicationListener.getParsedDocument(resource);
                String resourceURI = doc.getDocumentElement().getAttribute("resourceURI");
                this.existingMPs.add(resourceURI);
            } else if (resource.getFullPath().toString().endsWith(".SimulizarProfile.pa.xmi")) {
                Document doc = StereotypeApplicationListener.getParsedDocument(resource);
                NodeList appliedToList = doc.getElementsByTagName("appliedTo");
                int i = 0;
                while (i < appliedToList.getLength()) {
                    Element appliedTo = (Element)appliedToList.item(i);
                    String href = appliedTo.getAttribute("href");
                    this.existingSAs.put(href, resource);
                    ++i;
                }
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException("A problem with IO occured.");
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("A problem with configuring the parser occured.");
        }
        catch (SAXException e) {
            throw new RuntimeException("A problem with SAX parser occured.");
        }
        return true;
    }
}

