/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.measuringpoint.create;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.palladiosimulator.simulizar.measuringpoint.create.StereotypeApplicationListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    private static final String HREF_ATTRIBUTE_NAME = "href";
    private static final String APPLIED_TO_ELEMENT_NAME = "appliedTo";
    private static final String MEASURING_POINT_STEREOTYPE_APPLICATION_FILE_EXTENSION = ".SimulizarProfile.pa.xmi";
    private static final String RESOURCE_URI_ATTRIBUTE_NAME = "resourceURI";
    private static final String MEASURING_POINT_FILE_EXTENSION = ".measuringpoint";
    public static final String PLUGIN_ID = "org.palladiosimulator.simulizar.example";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void earlyStartup() {
        Set<String> elements = this.getElementsWithStereotypes();
        this.filterOutElementsWithNotMeasuringPointFiles(elements);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addResourceChangeListener((IResourceChangeListener)new StereotypeApplicationListener(elements));
    }

    private void filterOutElementsWithNotMeasuringPointFiles(Set<String> elements) {
        try {
            IProject[] projects;
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject[] iProjectArray = projects = ws.getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    IResource[] resources;
                    IResource[] iResourceArray = resources = project.members();
                    int n3 = resources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String resourceURI;
                        IResource r = iResourceArray[n4];
                        if (r.getFullPath().lastSegment() != null && r.getFullPath().lastSegment().endsWith(MEASURING_POINT_FILE_EXTENSION) && elements.contains(resourceURI = this.getResourceUriOfTheElement(r))) {
                            elements.add(resourceURI);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String getResourceUriOfTheElement(IResource r) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(r.getLocation().toFile());
            String resourceURI = doc.getDocumentElement().getAttribute(RESOURCE_URI_ATTRIBUTE_NAME);
            return resourceURI;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Set<String> getElementsWithStereotypes() {
        try {
            IProject[] projects;
            HashSet<String> res = new HashSet<String>();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject[] iProjectArray = projects = ws.getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    IResource[] resources;
                    IResource[] iResourceArray = resources = project.members();
                    int n3 = resources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource r = iResourceArray[n4];
                        if (r.getFullPath().lastSegment() != null && r.getFullPath().lastSegment().endsWith(MEASURING_POINT_STEREOTYPE_APPLICATION_FILE_EXTENSION)) {
                            res.addAll(this.collectResourceUris(r));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return res;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Set<String> collectResourceUris(IResource r) {
        try {
            HashSet<String> res = new HashSet<String>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(r.getLocation().toFile());
            NodeList appliedToList = doc.getElementsByTagName(APPLIED_TO_ELEMENT_NAME);
            int i = 0;
            while (i < appliedToList.getLength()) {
                Element appliedTo = (Element)appliedToList.item(i);
                String href = appliedTo.getAttribute(HREF_ATTRIBUTE_NAME);
                res.add(href);
                ++i;
            }
            return res;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

