/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.measuringpoint.create;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointPackage;
import org.palladiosimulator.simulizar.measuringpoint.create.ResourceURIsFromMPsExtractor;
import org.palladiosimulator.simulizar.measuringpoint.create.ResourceURIsFromSAsExtractor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StereotypeApplicationListener
implements IResourceChangeListener {
    private final Logger logger = Logger.getLogger(StereotypeApplicationListener.class.getName());
    public static final String RESOURCE_URI_ATTRIBUTE_NAME = "resourceURI";
    private static final String RESOURCE_URI_DELIMITER = "/";
    private static final int PROJECT_NAME_POSITION_INSIDE_RESOURCE_URI = 2;
    private static final String CREATE_MEASURING_POINT_FILE_JOB_NAME = "Add a measuring point";
    public static final String APPLIED_TO_ELEMENT_TAG_NAME = "appliedTo";
    private static final String ELEMENT_ID_PREFIX = "platform:/resource";
    public static final String HREF_ATTRIBUTE_NAME = "href";
    public static final String MEASURING_POINT_FILE_EXTENSION = ".measuringpoint";
    public static final String MEASURING_POINT_STEREOTYPE_APPLICATION_FILE_EXTENSION = ".SimulizarProfile.pa.xmi";
    private static final String REPOSITORY_FILE_EXTENSION = ".repository#";
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String DELETE_RESOURCE_JOB_NAME = "Delete resource job";
    private Set<String> oldResourceURIs;

    public StereotypeApplicationListener(Set<String> currentIds) {
        this.oldResourceURIs = currentIds;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            Set<IProject> projectsOfCreatedMPs;
            Set<IProject> projectsOfDeletedMPs;
            IProject[] allWorkspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            Set<String> newResourceURIs = this.getMonitoredElementsForMeasuringPoints(allWorkspaceProjects);
            if (!newResourceURIs.isEmpty()) {
                HashSet<String> resourceURIsToCreate = new HashSet<String>();
                for (String resourceURI : newResourceURIs) {
                    if (this.oldResourceURIs.contains(resourceURI)) continue;
                    resourceURIsToCreate.add(resourceURI);
                }
                ArrayList<String> resourceURIsToDelete = new ArrayList<String>();
                for (String string : this.oldResourceURIs) {
                    if (newResourceURIs.contains(string)) continue;
                    resourceURIsToDelete.add(string);
                }
                this.createMeasuringPoints(resourceURIsToCreate);
                this.deleteMeasuringPoints(resourceURIsToDelete);
                this.oldResourceURIs = new HashSet<String>(newResourceURIs);
            }
            if ((projectsOfDeletedMPs = this.getProjectsOfCreatedOrDeletedMeasuringPoints(event.getDelta(), 2)) != null) {
                for (IProject p : projectsOfDeletedMPs) {
                    this.adaptPaXmisToDeletedMeasuringPoints(p);
                }
            }
            if ((projectsOfCreatedMPs = this.getProjectsOfCreatedOrDeletedMeasuringPoints(event.getDelta(), 1)) != null) {
                for (IProject iProject : projectsOfCreatedMPs) {
                    this.adaptPaXmisToDeletedMeasuringPoints(iProject);
                }
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | CoreException | SAXException e) {
            this.logger.log(Level.SEVERE, "An error occured while handling measuring point stereotype appliciont!");
            e.printStackTrace();
        }
    }

    private Set<IProject> getProjectsOfCreatedOrDeletedMeasuringPoints(IResourceDelta delta, int status) {
        IResource r;
        String fileName;
        HashSet<IProject> res = new HashSet<IProject>();
        if (delta != null && delta.getResource() != null && (fileName = (r = delta.getResource()).getFullPath().toString()).endsWith(MEASURING_POINT_FILE_EXTENSION) && delta.getKind() == status) {
            res.add(r.getProject());
            return res;
        }
        if (delta != null) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta d = iResourceDeltaArray[n2];
                res.addAll(this.getProjectsOfCreatedOrDeletedMeasuringPoints(d, status));
                ++n2;
            }
        }
        return res;
    }

    private void deleteMeasuringPoints(List<String> measuringPointsToDelete) throws CoreException, ParserConfigurationException, SAXException, IOException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<IProject, ArrayList<String>> projectsWithMPsToDelete = new HashMap<IProject, ArrayList<String>>();
        for (String string : measuringPointsToDelete) {
            String[] res = string.split(RESOURCE_URI_DELIMITER);
            IProject project = wsRoot.getProject(res[2]);
            ArrayList<String> mps = (ArrayList<String>)projectsWithMPsToDelete.get(project);
            if (mps == null) {
                mps = new ArrayList<String>();
            }
            mps.add(string);
            projectsWithMPsToDelete.put(project, mps);
        }
        for (Map.Entry entry : projectsWithMPsToDelete.entrySet()) {
            IResource[] iResourceArray = ((IProject)entry.getKey()).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.getFullPath().toString().endsWith(MEASURING_POINT_FILE_EXTENSION)) {
                    Document doc = StereotypeApplicationListener.getParsedDocument(r);
                    String resourceURI = doc.getDocumentElement().getAttribute(RESOURCE_URI_ATTRIBUTE_NAME);
                    if (((List)entry.getValue()).contains(resourceURI)) {
                        this.deleteResource(r);
                    }
                }
                ++n2;
            }
        }
    }

    private void createMeasuringPoints(Set<String> resourceURIs) {
        for (final String resourceURI : resourceURIs) {
            WorkspaceJob mpCreateJob = new WorkspaceJob(CREATE_MEASURING_POINT_FILE_JOB_NAME){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        StereotypeApplicationListener.this.createMeasuringPoint(resourceURI);
                    }
                    catch (IOException e) {
                        StereotypeApplicationListener.this.logger.log(Level.SEVERE, "Measuring point for \"" + resourceURI + "\" could not be created!");
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            mpCreateJob.schedule();
        }
    }

    private void adaptPaXmisToDeletedMeasuringPoints(IProject project) throws ParserConfigurationException, SAXException, IOException, TransformerException, CoreException {
        ArrayList<String> existingMPs = new ArrayList<String>();
        HashMap<String, IResource> existingSAs = new HashMap<String, IResource>();
        if (project.isOpen()) {
            project.accept((IResourceVisitor)new ResourceURIsFromMPsExtractor(existingMPs, existingSAs), 2, true);
        }
        for (Map.Entry entry : existingSAs.entrySet()) {
            if (existingMPs.contains(entry.getKey())) continue;
            this.deleteElementFromPaXmi((String)entry.getKey(), (IResource)entry.getValue());
            this.oldResourceURIs.remove(entry.getKey());
        }
    }

    public static Document getParsedDocument(IResource r) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(r.getLocation().toFile());
        return doc;
    }

    private void deleteElementFromPaXmi(String resourceURI, IResource resource) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        Document doc = StereotypeApplicationListener.getParsedDocument(resource);
        NodeList appliedToList = doc.getElementsByTagName(APPLIED_TO_ELEMENT_TAG_NAME);
        int i = 0;
        while (i < appliedToList.getLength()) {
            Element appliedTo = (Element)appliedToList.item(i);
            String href = appliedTo.getAttribute(HREF_ATTRIBUTE_NAME);
            if (href.equals(resourceURI)) {
                Node stereotypeApplication = appliedTo.getParentNode();
                Node rootNode = stereotypeApplication.getParentNode();
                rootNode.removeChild(stereotypeApplication);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(resource.getLocation().toFile());
                transformer.transform(source, result);
            }
            ++i;
        }
    }

    private void deleteResource(final IResource resource) {
        WorkspaceJob deleteJob = new WorkspaceJob(DELETE_RESOURCE_JOB_NAME){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ex) {
                    StereotypeApplicationListener.this.logger.log(Level.SEVERE, "The resourece \"" + resource.getName() + "\" could not be deleted!");
                    ex.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        deleteJob.schedule();
    }

    private String getMeasuringPointName(String resourceURI) {
        String fileName = resourceURI.replace(ELEMENT_ID_PREFIX, "");
        fileName = fileName.replace(REPOSITORY_FILE_EXTENSION, "");
        fileName = String.valueOf(fileName) + MEASURING_POINT_FILE_EXTENSION;
        return fileName;
    }

    private Set<String> getMonitoredElementsForMeasuringPoints(IProject[] projects) throws ParserConfigurationException, SAXException, IOException, TransformerException, CoreException {
        HashMap<String, IProject> map = new HashMap<String, IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                project.accept((IResourceVisitor)new ResourceURIsFromSAsExtractor(map), 2, true);
            }
            ++n2;
        }
        return map.keySet();
    }

    public void createMeasuringPoint(String resourceURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String fileName = this.getMeasuringPointName(resourceURI);
        URI fileURI = URI.createPlatformResourceURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        MeasuringpointPackage measuringpointPackage = MeasuringpointPackage.eINSTANCE;
        MeasuringpointFactory measuringpointFactory = measuringpointPackage.getMeasuringpointFactory();
        EClass measuringPoint = measuringpointPackage.getResourceURIMeasuringPoint();
        EObject rootObject = measuringpointFactory.create(measuringPoint);
        EAttribute resourceURIAttribute = measuringpointPackage.getResourceURIMeasuringPoint_ResourceURI();
        rootObject.eSet((EStructuralFeature)resourceURIAttribute, (Object)resourceURI);
        if (rootObject != null) {
            resource.getContents().add((Object)rootObject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", UTF8_ENCODING);
        resource.save(options);
    }
}

