/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.henshin;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.core.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.reconfiguration.henshin.HenshinModelTransformation;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;

public class HenshinReconfigurator
extends AbstractReconfigurator {
    private static final Logger LOGGER = Logger.getLogger(HenshinReconfigurator.class);

    public void setConfiguration(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    private boolean executeReconfiguration(UnitApplication app, Module module) {
        LOGGER.info((Object)"Called Henshin reconfiguration engine.");
        EGraphImpl graph = new EGraphImpl((EObject)this.pcmPartitionManager.getGlobalPCMModel().getAllocation());
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("execute"));
        if (app.execute(null)) {
            LOGGER.debug((Object)"Successfully executed Henshin rule.");
            return true;
        }
        LOGGER.debug((Object)"Executing Henshin rule failed.");
        return false;
    }

    private boolean analyzeReconfiguration(UnitApplication app, Module module) {
        RuntimeMeasurementModel rmModel = (RuntimeMeasurementModel)this.pcmPartitionManager.findModel(RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel());
        EGraphImpl graph = new EGraphImpl((EObject)rmModel);
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("analyze"));
        if (app.execute(null)) {
            LOGGER.debug((Object)"Found matching Henshin rule.");
            return true;
        }
        LOGGER.debug((Object)"No matching Henshin rule found.");
        return false;
    }

    public boolean runCheck(List<? extends ModelTransformation<? extends Object>> checks, EObject monitoredElement, IResourceTableManager resourceTableManager, Map<String, Object> configParams) {
        return false;
    }

    public boolean runExecute(List<? extends ModelTransformation<? extends Object>> actions, EObject monitoredElement, IResourceTableManager resourceTableManager) {
        Map<String, Object> configParams = Collections.emptyMap();
        return this.runExecute(actions, monitoredElement, resourceTableManager, configParams);
    }

    public boolean runExecute(List<? extends ModelTransformation<? extends Object>> actions, EObject monitoredElement, IResourceTableManager resourceTableManager, Map<String, Object> configParams) {
        ArrayList<HenshinModelTransformation> transformations = new ArrayList<HenshinModelTransformation>();
        LOGGER.info((Object)"Executing Story Diagram Model Transformation.");
        for (ModelTransformation<? extends Object> modelTransformation : actions) {
            try {
                if (!(modelTransformation instanceof HenshinModelTransformation)) continue;
                HenshinModelTransformation henshinModelTransformation = (HenshinModelTransformation)modelTransformation;
                transformations.add(henshinModelTransformation);
            }
            catch (ClassCastException e) {
                LOGGER.info((Object)"Not a Storydiagram model transformation.");
            }
        }
        return this.executeTransformations(transformations);
    }

    private boolean executeTransformations(List<HenshinModelTransformation> transformations) {
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine);
        boolean result = false;
        for (HenshinModelTransformation transformation : transformations) {
            if (!this.analyzeReconfiguration((UnitApplication)app, (Module)transformation.getModelTransformation())) continue;
            result |= this.executeReconfiguration((UnitApplication)app, (Module)transformation.getModelTransformation());
        }
        return result;
    }
}

