/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto.util;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.palladiosimulator.analyzer.workflow.core.jobs.LoadSharedPCMLibrariesIntoBlackboard;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;

public class QVToModelCache {
    private final Map<EPackage, Set<EObject>> cache = new HashMap<EPackage, Set<EObject>>();
    private final PCMPartitionManager pcmPartitionManager;
    private static final EClass[] MODEL_ECLASS_BLACKLIST = new EClass[0];
    private static final EcoreSwitch<EPackage> MODELTYPE_RETRIEVER = new EcoreSwitch<EPackage>(){

        public EPackage caseEPackage(EPackage ePackage) {
            return ePackage;
        }

        public EPackage caseEClass(EClass eClass) {
            return (EPackage)this.doSwitch(eClass.eContainer());
        }

        public EPackage defaultCase(EObject eObject) {
            return (EPackage)this.doSwitch((EObject)eObject.eClass());
        }
    };

    public QVToModelCache(PCMPartitionManager pcmPartitonManager) {
        this.pcmPartitionManager = Objects.requireNonNull(pcmPartitonManager, "pcmPartitonManager must not be null.");
        this.storeBlackboardModels();
    }

    private QVToModelCache(QVToModelCache from) {
        this.pcmPartitionManager = from.pcmPartitionManager;
        Objects.requireNonNull(from);
        from.cache.values().stream().flatMap(Collection::stream).forEach(this::storeModel);
    }

    public void storeModel(EObject modelInstance) {
        if (modelInstance != null) {
            EPackage metaModel = (EPackage)MODELTYPE_RETRIEVER.doSwitch(modelInstance);
            if (modelInstance.equals(metaModel)) {
                return;
            }
            Optional.ofNullable(this.cache.get(metaModel)).orElseGet(() -> {
                this.cache.put(metaModel, new HashSet());
                return this.cache.get(metaModel);
            }).add(modelInstance);
        }
    }

    public final void storeModelFromBlackboardPartition(String partitionId) {
        MDSDBlackboard blackboard = this.pcmPartitionManager.getBlackboard();
        if (blackboard.hasPartition(Objects.requireNonNull(partitionId, "partitionId must not be null."))) {
            ResourceSetPartition partition = (ResourceSetPartition)blackboard.getPartition(partitionId);
            partition.getResourceSet().getResources().stream().map(Resource::getContents).filter(contents -> !contents.isEmpty() && !QVToModelCache.isBlacklisted((EObject)contents.get(0))).forEach(contents -> this.storeModel((EObject)contents.get(0)));
        }
    }

    public void removeModelOfType(EPackage metaModel) {
        if (metaModel != null) {
            this.cache.remove(metaModel);
        }
    }

    public void removeModel(EObject model) {
        if (model != null) {
            this.cache.get(MODELTYPE_RETRIEVER.doSwitch(model)).remove(model);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public QVToModelCache snapshot() {
        return new QVToModelCache(this);
    }

    public Collection<EObject> getModelsByType(EPackage ePackage) {
        String namespace = Objects.requireNonNull(ePackage.getNsURI());
        Collection res = this.cache.keySet().stream().filter(key -> key.getNsURI().equals(namespace)).collect(Collectors.toList());
        Collection result = res.stream().map(this.cache::get).collect(Collectors.toList());
        return result.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean containsModelOfType(EPackage ePackage) {
        return this.cache.containsKey(Objects.requireNonNull(ePackage));
    }

    private void storeBlackboardModels() {
        assert (this.pcmPartitionManager != null);
        HashSet partitions = new HashSet(this.pcmPartitionManager.getBlackboard().getPartitionIds());
        partitions.remove("org.palladiosimulator.pcmmodels.partition");
        partitions.forEach(this::storeModelFromBlackboardPartition);
        this.storeModelFromBlackboardPartition("org.palladiosimulator.pcmmodels.partition");
    }

    private static boolean isBlacklisted(EObject model) {
        assert (model != null);
        return model.eResource().getURI().equals(LoadSharedPCMLibrariesIntoBlackboard.PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI) || Arrays.stream(MODEL_ECLASS_BLACKLIST).anyMatch(bannedEClass -> bannedEClass == model.eClass());
    }
}

