/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.simulizar.core.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.di.base.scopes.RuntimeExtensionScope;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.ModelTransformationCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;

@RuntimeExtensionScope
public class QVTOReconfigurator
extends AbstractReconfigurator {
    private static final Logger LOGGER = Logger.getLogger(QVTOReconfigurator.class);
    private QVTOExecutor qvtoExecutor;

    @Inject
    public QVTOReconfigurator(SimuLizarWorkflowConfiguration configuration, PCMPartitionManager partitionManager) {
        this.configuration = configuration;
        this.pcmPartitionManager = partitionManager;
    }

    private QVTOExecutor getQVTOExecutor() {
        if (this.qvtoExecutor == null) {
            this.qvtoExecutor = new QVTOExecutor(new ModelTransformationCache(new URI[0]), new QVToModelCache(this.pcmPartitionManager));
        }
        return this.qvtoExecutor;
    }

    public boolean runCheck(List<? extends ModelTransformation<? extends Object>> checks, EObject monitoredElement, IResourceTableManager resourceTableManager, Map<String, Object> configParams) {
        return this.runExecute(checks, monitoredElement, resourceTableManager, configParams);
    }

    public boolean runExecute(List<? extends ModelTransformation<? extends Object>> actions, EObject monitoredElement, IResourceTableManager resourceTableManager) {
        Map<String, Object> configParams = Collections.emptyMap();
        return this.runExecute(actions, monitoredElement, resourceTableManager, configParams);
    }

    public boolean runExecute(List<? extends ModelTransformation<? extends Object>> actions, EObject monitoredElement, IResourceTableManager resourceTableManager, Map<String, Object> configParams) {
        LOGGER.debug((Object)"Checking reconfiguration rules due to PRM change");
        ArrayList<QvtoModelTransformation> transformations = new ArrayList<QvtoModelTransformation>();
        for (ModelTransformation<? extends Object> modelTransformation : actions) {
            try {
                if (!(modelTransformation instanceof QvtoModelTransformation)) continue;
                transformations.add((QvtoModelTransformation)modelTransformation);
            }
            catch (ClassCastException e) {
                LOGGER.debug((Object)"Not a QVTO model transformation.");
            }
        }
        boolean bl = this.getQVTOExecutor().executeTransformations(transformations, resourceTableManager, configParams);
        LOGGER.debug((Object)(bl ? "Reconfigured system by a matching rule" : "No reconfiguration rule was executed, all conditions were false"));
        return bl;
    }
}

