/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.PredicateUtils;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOTransformationExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.TransformationParameterInformation;
import org.palladiosimulator.simulizar.reconfigurationrule.impl.ModelTransformationImpl;

public class QvtoModelTransformation
extends ModelTransformationImpl<OperationalTransformation> {
    private final QVTOTransformationExecutor transformationExecutor;
    private final Collection<TransformationParameterInformation> inParams;
    private final Collection<TransformationParameterInformation> outParams;
    private static final Predicate<TransformationParameterInformation> PURE_OUT_PARAM_PREDICATE = new Predicate<TransformationParameterInformation>(){

        public boolean evaluate(TransformationParameterInformation transformationParameterInformation) {
            return transformationParameterInformation.isOutParameter();
        }
    };
    private static final Predicate<TransformationParameterInformation> IN_INOUT_PARAM_PREDICATE = PredicateUtils.notPredicate(PURE_OUT_PARAM_PREDICATE);

    public QvtoModelTransformation(OperationalTransformation transformation, QVTOTransformationExecutor executor, Collection<TransformationParameterInformation> paramInfo) {
        this.modelTransformation = transformation;
        this.transformationExecutor = executor;
        this.inParams = Collections.unmodifiableCollection(CollectionUtils.select(paramInfo, IN_INOUT_PARAM_PREDICATE));
        this.outParams = Collections.unmodifiableCollection(CollectionUtils.select(paramInfo, PURE_OUT_PARAM_PREDICATE));
    }

    public int getParameterCount() {
        return this.inParams.size() + this.outParams.size();
    }

    public Collection<TransformationParameterInformation> getPureOutParameters() {
        return this.outParams;
    }

    public Collection<TransformationParameterInformation> getInParameters() {
        return this.inParams;
    }

    public String getTransformationName() {
        return ((OperationalTransformation)this.modelTransformation).getName();
    }

    public QVTOTransformationExecutor getTransformationExecutor() {
        return this.transformationExecutor;
    }
}

