/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reliability.interpreter.listener;

import de.uka.ipd.sdq.simucomframework.core.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.SupplementaryMeasurementAttachingProbe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.simulizar.core.entity.InterpretableLocationReference;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.di.base.scopes.RuntimeExtensionScope;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.listener.InterpreterResultListener;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;
import org.palladiosimulator.simulizar.reliability.probe.ExecutionResultTypeProbe;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

@RuntimeExtensionScope
public class ReliabilityProbeFrameworkAdapter
implements InterpreterResultListener,
IModelObserver {
    private final ResourceSetPartition globalPartition;
    private final Map<String, ExecutionResultTypeProbe> probeRegister;
    private final IGenericCalculatorFactory calculatorFactory;
    private final Provider<TakeCurrentSimulationTimeProbe> simulationTimeProbeFactory;

    @Inject
    public ReliabilityProbeFrameworkAdapter(@PCMPartitionManager.Global PCMResourceSetPartition globalPartition, IGenericCalculatorFactory calculatorFactory, Provider<TakeCurrentSimulationTimeProbe> simulationTimeProbeFactory) {
        this.globalPartition = globalPartition;
        this.calculatorFactory = calculatorFactory;
        this.simulationTimeProbeFactory = simulationTimeProbeFactory;
        this.probeRegister = new HashMap<String, ExecutionResultTypeProbe>();
    }

    public void initialize() {
        EContentAdapter adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
            }
        };
        this.globalPartition.getElement(MonitorRepositoryPackage.Literals.MONITOR_REPOSITORY).forEach(arg_0 -> this.lambda$0(adapter, arg_0));
    }

    protected void addMonitorRepository(MonitorRepository repo) {
        repo.getMonitors().stream().flatMap(monitor -> monitor.getMeasurementSpecifications().stream().filter(spec -> MetricDescriptionConstants.EXECUTION_RESULT_TYPE_TUPLE.getId().equals(spec.getMetricDescription().getId()))).forEach(this::addMeasurementSpec);
    }

    protected void addMeasurementSpec(MeasurementSpecification spec) {
        MeasuringPoint measuringPoint = spec.getMonitor().getMeasuringPoint();
        String measurementIdentifier = MonitorRepositoryUtil.getMeasurementIdentifier((MeasuringPoint)measuringPoint);
        ExecutionResultTypeProbe probe = new ExecutionResultTypeProbe();
        SupplementaryMeasurementAttachingProbe composedProbe = new SupplementaryMeasurementAttachingProbe(MetricDescriptionConstants.EXECUTION_RESULT_TYPE_TUPLE, (Probe)probe, Collections.singletonList((TriggeredProbe)this.simulationTimeProbeFactory.get()));
        this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.EXECUTION_RESULT_TYPE_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)composedProbe));
        this.probeRegister.put(measurementIdentifier, probe);
    }

    public void interpretationFinished(InterpretableLocationReference interpretableLocation, InterpreterResult result, InterpreterDefaultContext context) {
        ExecutionResultTypeProbe probe = this.probeRegister.get(interpretableLocation.getLocationIdentifier());
        if (probe != null) {
            probe.measureExecutionResultType(result, context.getThread().getRequestContext());
        }
    }

    public void unregister() {
        this.probeRegister.clear();
    }

    private /* synthetic */ void lambda$0(1 var1_1, EObject repo) {
        repo.eAdapters().add((Object)var1_1);
        this.addMonitorRepository((MonitorRepository)repo);
    }
}

