/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.simucomframework.core.resources.IAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.composition.util.CompositionSwitch;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simulizar.core.entity.EntityReference;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RepositoryComponentSwitch;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionInterpreter;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultHandler;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResumptionPolicy;

public class ComposedStructureInnerSwitch
extends CompositionSwitch<InterpreterResult> {
    protected static final Logger LOGGER = Logger.getLogger((String)ComposedStructureInnerSwitch.class.getName());
    private final InterpreterDefaultContext context;
    private final Signature signature;
    private final RequiredRole requiredRole;
    private final ITransmissionInterpreter<EntityReference<ResourceContainer>, SimulatedStackframe<Object>, InterpreterDefaultContext> transmissionInterpreter;
    private final IAssemblyAllocationLookup<EntityReference<ResourceContainer>> resourceContainerLookup;
    private final Factory composedStructureSwitchFactory;
    private final RepositoryComponentSwitch.Factory repositoryComponentSwitchFactory;
    private final InterpreterResultMerger resultMerger;
    private final InterpreterResultHandler issueHandler;

    @AssistedInject
    ComposedStructureInnerSwitch(@Assisted InterpreterDefaultContext context, @Assisted Signature operationSignature, @Assisted RequiredRole requiredRole, ITransmissionInterpreter<EntityReference<ResourceContainer>, SimulatedStackframe<Object>, InterpreterDefaultContext> transmissionInterpreter, IAssemblyAllocationLookup<EntityReference<ResourceContainer>> resourceContainerLookup, Factory composedStructureSwitchFactory, RepositoryComponentSwitch.Factory repositoryComponentSwitchFactory, InterpreterResultHandler issueHandler, InterpreterResultMerger resultMerger) {
        this.context = context;
        this.signature = operationSignature;
        this.requiredRole = requiredRole;
        this.transmissionInterpreter = transmissionInterpreter;
        this.resourceContainerLookup = resourceContainerLookup;
        this.composedStructureSwitchFactory = composedStructureSwitchFactory;
        this.repositoryComponentSwitchFactory = repositoryComponentSwitchFactory;
        this.issueHandler = issueHandler;
        this.resultMerger = resultMerger;
    }

    public InterpreterResult caseAssemblyConnector(AssemblyConnector assemblyConnector) {
        EntityReference<ResourceContainer> target;
        RepositoryComponentSwitch repositoryComponentSwitch = this.repositoryComponentSwitchFactory.create(this.context, assemblyConnector.getProvidingAssemblyContext_AssemblyConnector(), this.signature, (ProvidedRole)assemblyConnector.getProvidedRole_AssemblyConnector());
        EntityReference<ResourceContainer> source = this.getAllocationTarget(assemblyConnector.getRequiringAssemblyContext_AssemblyConnector());
        InterpreterResult result = this.transmissionInterpreter.interpretTransmission(source, target = this.getAllocationTarget(assemblyConnector.getProvidingAssemblyContext_AssemblyConnector()), (SimulatedStackframe<Object>)this.context.getStack().currentStackFrame(), this.context);
        if (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE) {
            result = this.resultMerger.merge(result, (InterpreterResult)repositoryComponentSwitch.doSwitch((EObject)assemblyConnector.getProvidedRole_AssemblyConnector()));
        }
        if (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE) {
            result = this.resultMerger.merge(result, this.transmissionInterpreter.interpretTransmission(target, source, this.context.getResultFrameStack().peek(), this.context));
        }
        return result;
    }

    protected EntityReference<ResourceContainer> getAllocationTarget(AssemblyContext ctx) {
        String fqid = this.getFQComponentID(ctx);
        return Objects.requireNonNull((EntityReference)this.resourceContainerLookup.getAllocatedEntity(fqid), "No allocation registered for assembly context " + fqid);
    }

    protected String getFQComponentID(AssemblyContext ctx) {
        Stack<AssemblyContext> contextStack = this.context.getAssemblyContextStack();
        if (contextStack.size() < 2) {
            return ctx.getId();
        }
        return Stream.concat(contextStack.subList(1, contextStack.size()).stream(), Stream.of(ctx)).map(Identifier::getId).collect(Collectors.joining("::"));
    }

    public InterpreterResult caseAssemblyInfrastructureConnector(AssemblyInfrastructureConnector assemblyInfrastructureConnector) {
        RepositoryComponentSwitch repositoryComponentSwitch = this.repositoryComponentSwitchFactory.create(this.context, assemblyInfrastructureConnector.getProvidingAssemblyContext__AssemblyInfrastructureConnector(), this.signature, (ProvidedRole)assemblyInfrastructureConnector.getProvidedRole__AssemblyInfrastructureConnector());
        return (InterpreterResult)repositoryComponentSwitch.doSwitch((EObject)assemblyInfrastructureConnector.getProvidedRole__AssemblyInfrastructureConnector());
    }

    public InterpreterResult caseRequiredDelegationConnector(RequiredDelegationConnector requiredDelegationConnector) {
        AssemblyContext parentContext = this.context.getAssemblyContextStack().pop();
        ComposedStructureInnerSwitch composedStructureInnerSwitch = this.composedStructureSwitchFactory.create(this.context, this.signature, (RequiredRole)requiredDelegationConnector.getOuterRequiredRole_RequiredDelegationConnector());
        InterpreterResult result = (InterpreterResult)composedStructureInnerSwitch.doSwitch((EObject)parentContext);
        this.context.getAssemblyContextStack().push(parentContext);
        return result;
    }

    public InterpreterResult caseRequiredInfrastructureDelegationConnector(RequiredInfrastructureDelegationConnector requiredInfrastructureDelegationConnector) {
        AssemblyContext parentContext = this.context.getAssemblyContextStack().pop();
        ComposedStructureInnerSwitch composedStructureInnerSwitch = this.composedStructureSwitchFactory.create(this.context, this.signature, (RequiredRole)requiredInfrastructureDelegationConnector.getOuterRequiredRole__RequiredInfrastructureDelegationConnector());
        InterpreterResult result = (InterpreterResult)composedStructureInnerSwitch.doSwitch((EObject)parentContext);
        this.context.getAssemblyContextStack().push(parentContext);
        return result;
    }

    public InterpreterResult caseAssemblyContext(AssemblyContext assemblyContext) {
        Connector connector = ComposedStructureInnerSwitch.getConnectedConnector(assemblyContext, this.requiredRole);
        return (InterpreterResult)this.doSwitch((EObject)connector);
    }

    private static Connector getConnectedConnector(final AssemblyContext myContext, final RequiredRole requiredRole) {
        if (myContext == null) {
            throw new IllegalArgumentException("Assembly context must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Required role must not be null");
        }
        CompositionSwitch<Connector> connectorSelector = new CompositionSwitch<Connector>(){

            public Connector caseRequiredDelegationConnector(RequiredDelegationConnector delegationConnector) {
                if (delegationConnector.getAssemblyContext_RequiredDelegationConnector() == myContext && delegationConnector.getInnerRequiredRole_RequiredDelegationConnector() == requiredRole) {
                    return delegationConnector;
                }
                return null;
            }

            public Connector caseAssemblyConnector(AssemblyConnector assemblyConnector) {
                if (assemblyConnector.getRequiringAssemblyContext_AssemblyConnector() == myContext && assemblyConnector.getRequiredRole_AssemblyConnector() == requiredRole) {
                    return assemblyConnector;
                }
                return null;
            }

            public Connector caseAssemblyInfrastructureConnector(AssemblyInfrastructureConnector assemblyInfrastructureConnector) {
                if (assemblyInfrastructureConnector.getRequiringAssemblyContext__AssemblyInfrastructureConnector() == myContext && assemblyInfrastructureConnector.getRequiredRole__AssemblyInfrastructureConnector() == requiredRole) {
                    return assemblyInfrastructureConnector;
                }
                return null;
            }

            public Connector caseRequiredInfrastructureDelegationConnector(RequiredInfrastructureDelegationConnector requiredInfrastructureDelegationConnector) {
                if (requiredInfrastructureDelegationConnector.getAssemblyContext__RequiredInfrastructureDelegationConnector() == myContext && requiredInfrastructureDelegationConnector.getInnerRequiredRole__RequiredInfrastructureDelegationConnector() == requiredRole) {
                    return requiredInfrastructureDelegationConnector;
                }
                return null;
            }
        };
        if (myContext.getParentStructure__AssemblyContext() == null) {
            throw new PCMModelInterpreterException("Required delegation of the system cannot be simulated");
        }
        for (Connector connector : myContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure()) {
            Connector result = (Connector)connectorSelector.doSwitch((EObject)connector);
            if (result == null) continue;
            return result;
        }
        throw new PCMModelInterpreterException("Found unbound provided role. PCM model is invalid.");
    }

    @AssistedFactory
    public static interface Factory {
        public ComposedStructureInnerSwitch create(InterpreterDefaultContext var1, Signature var2, RequiredRole var3);
    }
}

