/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.fork.ForkExecutor;
import de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.completions.DelegatingExternalCallAction;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.exceptions.SimulatedStackAccessException;
import org.palladiosimulator.simulizar.interpreter.ComposedStructureInnerSwitch;
import org.palladiosimulator.simulizar.interpreter.EventDispatcher;
import org.palladiosimulator.simulizar.interpreter.ForkedBehaviorProcessFactory;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RDSeffSwitchContributionFactory;
import org.palladiosimulator.simulizar.interpreter.listener.EventType;
import org.palladiosimulator.simulizar.interpreter.listener.RDSEFFElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultHandler;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResumptionPolicy;
import org.palladiosimulator.simulizar.runtimestate.ComponentInstanceRegistry;
import org.palladiosimulator.simulizar.runtimestate.PreInterpretationBehaviorManager;
import org.palladiosimulator.simulizar.runtimestate.SimulatedBasicComponentInstance;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;
import org.palladiosimulator.simulizar.utils.TransitionDeterminer;

public class RDSeffSwitch
extends SeffSwitch<InterpreterResult> {
    public static final Boolean SUCCESS = true;
    public static final String DEGREE_OF_CORRUPTION = "DEGREE_OF_CORRUPTION.VALUE";
    private static final Logger LOGGER = Logger.getLogger(RDSeffSwitch.class);
    private RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch;
    private final TransitionDeterminer transitionDeterminer;
    private final InterpreterDefaultContext context;
    private final SimulatedBasicComponentInstance basicComponentInstance;
    private final IResourceTableManager resourceTableManager;
    private final ComposedStructureInnerSwitch.Factory composedSwitchFactory;
    private final EventDispatcher eventHelper;
    private final InterpreterResultHandler issueHandler;
    private final InterpreterResultMerger resultMerger;
    private final ForkedBehaviorProcessFactory forkFactory;
    private final PreInterpretationBehaviorManager pibManager;

    @AssistedInject
    RDSeffSwitch(@Assisted InterpreterDefaultContext context, @Assisted RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch, IResourceTableManager resourceTableManager, ComponentInstanceRegistry componentInstanceRegistry, ComposedStructureInnerSwitch.Factory composedSwitchFactory, ForkedBehaviorProcessFactory forkFactory, EventDispatcher eventHelper, InterpreterResultHandler issueHandler, InterpreterResultMerger resultMerger, PreInterpretationBehaviorManager pibManager) {
        this.context = context;
        this.composedSwitchFactory = composedSwitchFactory;
        this.forkFactory = forkFactory;
        this.eventHelper = eventHelper;
        this.issueHandler = issueHandler;
        this.resultMerger = resultMerger;
        this.pibManager = pibManager;
        this.transitionDeterminer = new TransitionDeterminer(context);
        this.basicComponentInstance = Optional.ofNullable(componentInstanceRegistry.getComponentInstance(context.computeFQComponentID())).filter(SimulatedBasicComponentInstance.class::isInstance).map(SimulatedBasicComponentInstance.class::cast).orElseThrow(() -> new IllegalStateException("RDSeffSwitch requires an SimulatedBasicComponentInstance to be initialized already."));
        this.resourceTableManager = resourceTableManager;
        this.parentSwitch = parentSwitch;
    }

    /*
     * Unable to fully structure code
     */
    public InterpreterResult caseResourceDemandingBehaviour(ResourceDemandingBehaviour object) {
        stacksize = this.context.getStack().size();
        result = InterpreterResult.OK;
        currentAction = null;
        for (AbstractAction abstractAction : object.getSteps_Behaviour()) {
            if (abstractAction.eClass() != SeffPackage.eINSTANCE.getStartAction()) continue;
            this.firePassedEvent(abstractAction, EventType.BEGIN);
            if (this.pibManager.hasContainerAlreadyBeenRegisteredForEntity(abstractAction.eClass())) {
                pIBContainer = this.pibManager.getContainerForEntity(abstractAction.eClass());
                newResult = pIBContainer.executeBehaviors(this.context);
                result = this.resultMerger.merge(result, newResult);
            }
            currentAction = abstractAction.getSuccessor_AbstractAction();
            this.firePassedEvent(abstractAction, EventType.END);
            break;
        }
        if (currentAction != null) ** GOTO lbl27
        throw new PCMModelInterpreterException("RDSEFF is invalid, it misses a start action");
lbl-1000:
        // 1 sources

        {
            if (RDSeffSwitch.LOGGER.isDebugEnabled()) {
                RDSeffSwitch.LOGGER.debug((Object)("Interpret " + currentAction.eClass().getName() + ": " + currentAction));
            }
            this.firePassedEvent(currentAction, EventType.BEGIN);
            if (this.pibManager.hasContainerAlreadyBeenRegisteredForEntity(currentAction.getId())) {
                pIBContainer = this.pibManager.getContainerForEntity(currentAction.getId());
                newResult = pIBContainer.executeBehaviors(this.context);
                result = this.resultMerger.merge(result, newResult);
            }
            if (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE) {
                result = this.resultMerger.merge(result, this.parentSwitch.doSwitch((EObject)currentAction));
            }
            this.firePassedEvent(currentAction, EventType.END);
            currentAction = currentAction.getSuccessor_AbstractAction();
lbl27:
            // 2 sources

            ** while (this.issueHandler.handleIssues((InterpreterResult)result) == InterpreterResumptionPolicy.CONTINUE && currentAction.eClass() != SeffPackage.eINSTANCE.getStopAction())
        }
lbl28:
        // 1 sources

        if (this.context.getStack().size() != stacksize) {
            throw new PCMModelInterpreterException("Interpreter did not pop all pushed stackframes");
        }
        return result;
    }

    public InterpreterResult caseAbstractAction(AbstractAction object) {
        throw new UnsupportedOperationException("SEFF Interpreter tried to interpret unsupported action type: " + object.eClass().getName());
    }

    public InterpreterResult caseInternalAction(InternalAction internalAction) {
        InterpreterResult result = InterpreterResult.OK;
        this.context.getStack().createAndPushNewStackFrame(this.context.getStack().currentStackFrame());
        result = this.resultMerger.merge(result, this.invokeRecursiveAndHandleFailure((Collection<? extends EObject>)internalAction.getResourceDemand_Action()));
        result = this.resultMerger.merge(result, this.invokeRecursiveAndHandleFailure((Collection<? extends EObject>)internalAction.getInfrastructureCall__Action()));
        result = this.resultMerger.merge(result, this.invokeRecursiveAndHandleFailure((Collection<? extends EObject>)internalAction.getInternalFailureOccurrenceDescriptions__InternalAction()));
        result = this.resultMerger.merge(result, this.invokeRecursiveAndHandleFailure((Collection<? extends EObject>)internalAction.getResourceCall__Action()));
        this.context.getStack().removeStackFrame();
        return result;
    }

    private InterpreterResult invokeRecursiveAndHandleFailure(Collection<? extends EObject> nestedElements) {
        InterpreterResult result = InterpreterResult.OK;
        for (EObject eObject : nestedElements) {
            result = this.resultMerger.merge(result, this.parentSwitch.doSwitch(eObject));
        }
        return result;
    }

    public InterpreterResult caseExternalCallAction(ExternalCallAction externalCall) {
        ComposedStructureInnerSwitch composedStructureSwitch = this.composedSwitchFactory.create(this.context, (Signature)externalCall.getCalledService_ExternalService(), (RequiredRole)externalCall.getRole_ExternalService());
        if (externalCall instanceof DelegatingExternalCallAction) {
            SimulatedStackframe currentFrame = this.context.getStack().currentStackFrame();
            SimulatedStackframe<Object> callFrame = SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)externalCall.getInputVariableUsages__CallAction(), (SimulatedStackframe<Object>)currentFrame);
            callFrame.addVariables(this.context.getCurrentResultFrame());
        } else {
            SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)externalCall.getInputVariableUsages__CallAction());
        }
        AssemblyContext myContext = this.context.getAssemblyContextStack().pop();
        this.context.getResultFrameStack().push((SimulatedStackframe<Object>)new SimulatedStackframe());
        InterpreterResult result = (InterpreterResult)composedStructureSwitch.doSwitch((EObject)myContext);
        this.context.getAssemblyContextStack().push(myContext);
        this.context.getStack().removeStackFrame();
        SimulatedStackHelper.addParameterToStackFrame(this.context.getResultFrameStack().pop(), (EList<VariableUsage>)externalCall.getReturnVariableUsage__CallReturnAction(), (SimulatedStackframe<Object>)this.context.getStack().currentStackFrame());
        return result;
    }

    public InterpreterResult caseBranchAction(BranchAction object) {
        AbstractBranchTransition branchTransition;
        EList abstractBranchTransitions = object.getBranches_Branch();
        if (abstractBranchTransitions.isEmpty()) {
            throw new PCMModelInterpreterException("Empty branch action is not allowed");
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Branch \"");
            sb.append(object.getEntityName());
            sb.append("\" [ID: ");
            sb.append(object.getId());
            sb.append("\"] with ");
            sb.append(object.getBranches_Branch().size());
            sb.append(" branches.");
            LOGGER.debug((Object)sb.toString());
        }
        if ((branchTransition = this.transitionDeterminer.determineTransition((EList<AbstractBranchTransition>)abstractBranchTransitions)) == null) {
            LOGGER.error((Object)("No branch's condition evaluated to true, no branch selected: " + object));
            throw new PCMModelInterpreterException("No branch transition was active. This is not allowed.");
        }
        return this.parentSwitch.doSwitch((EObject)branchTransition.getBranchBehaviour_BranchTransition());
    }

    public InterpreterResult caseCollectionIteratorAction(CollectionIteratorAction object) {
        return this.iterateOverCollection(object, object.getParameter_CollectionIteratorAction());
    }

    public InterpreterResult caseForkAction(ForkAction object) {
        List<ForkedBehaviourProcess> asyncProcesses = this.getProcesses((List<ForkedBehaviour>)object.getAsynchronousForkedBehaviours_ForkAction(), true, this.resourceTableManager);
        List<ForkedBehaviourProcess> syncProcesses = this.determineSyncedProcesses(object, this.resourceTableManager);
        List<ForkedBehaviourProcess> combinedProcesses = this.combineProcesses(asyncProcesses, syncProcesses);
        ForkExecutor forkExecutor = new ForkExecutor(this.context.getThread(), combinedProcesses.toArray(new ForkedBehaviourProcess[0]));
        forkExecutor.run();
        return InterpreterResult.OK;
    }

    public InterpreterResult caseLoopAction(LoopAction object) {
        PCMRandomVariable iterationCount = object.getIterationCount_LoopAction();
        String stoex = iterationCount.getSpecification();
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)stoex, Integer.class, (SimulatedStackframe)this.context.getStack().currentStackFrame());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Determined number of loops: " + numberOfLoops + " " + object));
        }
        return this.interpretLoop(object, numberOfLoops);
    }

    public InterpreterResult caseSetVariableAction(SetVariableAction object) {
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe<Object>)this.context.getStack().currentStackFrame(), (EList<VariableUsage>)object.getLocalVariableUsages_SetVariableAction(), this.context.getCurrentResultFrame());
        return InterpreterResult.OK;
    }

    public InterpreterResult caseAcquireAction(AcquireAction acquireAction) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process " + this.context.getThread().getId() + " tries to acquire " + acquireAction.getPassiveresource_AcquireAction().getEntityName()));
        }
        this.basicComponentInstance.acquirePassiveResource(acquireAction.getPassiveresource_AcquireAction(), this.context, acquireAction.isTimeout(), acquireAction.getTimeoutValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process " + this.context.getThread().getId() + " successfully acquired " + acquireAction.getPassiveresource_AcquireAction().getEntityName()));
        }
        return InterpreterResult.OK;
    }

    public InterpreterResult caseReleaseAction(ReleaseAction releaseAction) {
        this.basicComponentInstance.releasePassiveResource(releaseAction.getPassiveResource_ReleaseAction(), this.context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process " + this.context.getThread().getId() + " released " + releaseAction.getPassiveResource_ReleaseAction().getEntityName()));
        }
        return InterpreterResult.OK;
    }

    private <T extends AbstractAction> void firePassedEvent(T abstractAction, EventType eventType) {
        this.eventHelper.firePassedEvent(new RDSEFFElementPassedEvent<T>(abstractAction, eventType, this.context, this.context.getAssemblyContextStack().peek()));
    }

    private List<ForkedBehaviourProcess> combineProcesses(List<ForkedBehaviourProcess> asyncProcesses, List<ForkedBehaviourProcess> syncProcesses) {
        LinkedList<ForkedBehaviourProcess> combinedProcesses = new LinkedList<ForkedBehaviourProcess>();
        combinedProcesses.addAll(asyncProcesses);
        combinedProcesses.addAll(syncProcesses);
        return Collections.synchronizedList(combinedProcesses);
    }

    private List<ForkedBehaviourProcess> determineSyncedProcesses(ForkAction object, IResourceTableManager resourceTableManager) {
        List<ForkedBehaviourProcess> syncProcesses = new ArrayList<ForkedBehaviourProcess>();
        if (object.getSynchronisingBehaviours_ForkAction() != null) {
            syncProcesses = this.getProcesses((List<ForkedBehaviour>)object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint(), false, resourceTableManager);
        }
        return syncProcesses;
    }

    private List<ForkedBehaviourProcess> getProcesses(List<ForkedBehaviour> forkedBehaviours, boolean isAsync, IResourceTableManager resourceTableManager) {
        return forkedBehaviours.stream().map(behavior -> this.forkFactory.create((ForkedBehaviour)behavior, this.context, isAsync)).collect(Collectors.toList());
    }

    private InterpreterResult interpretLoop(LoopAction object, int numberOfLoops) {
        InterpreterResult result = InterpreterResult.OK;
        int i = 0;
        while (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE && i < numberOfLoops) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Interpret loop number " + i + ": " + object));
            }
            result = this.resultMerger.merge(result, this.parentSwitch.doSwitch((EObject)object.getBodyBehaviour_Loop()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Finished loop number " + i + ": " + object));
            }
            ++i;
        }
        return result;
    }

    private InterpreterResult iterateOverCollection(CollectionIteratorAction object, Parameter parameter) {
        String idNumberOfLoops = String.valueOf(parameter.getParameterName()) + ".NUMBER_OF_ELEMENTS";
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)idNumberOfLoops, Integer.class, (SimulatedStackframe)this.context.getStack().currentStackFrame());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Determined number of loops: " + numberOfLoops + " " + object));
        }
        InterpreterResult result = InterpreterResult.OK;
        int i = 0;
        while (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE && i < numberOfLoops) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Interpret loop number " + i + ": " + object));
            }
            SimulatedStackframe innerVariableStackFrame = this.context.getStack().createAndPushNewStackFrame(this.context.getStack().currentStackFrame());
            this.context.evaluateInner(innerVariableStackFrame, String.valueOf(parameter.getParameterName()) + ".");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Created new stackframe with evaluated inner collection variables: " + innerVariableStackFrame));
            }
            result = this.resultMerger.merge(result, this.parentSwitch.doSwitch((EObject)object.getBodyBehaviour_Loop()));
            if (this.context.getStack().currentStackFrame() != innerVariableStackFrame) {
                throw new SimulatedStackAccessException("Inner value characterisations of inner collection variable expected");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Remove stack frame: " + innerVariableStackFrame));
            }
            this.context.getStack().removeStackFrame();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Finished loop number " + i + ": " + object));
            }
            ++i;
        }
        return result;
    }

    @AssistedFactory
    public static interface Factory
    extends RDSeffSwitchContributionFactory {
        public RDSeffSwitch createRDSeffSwitch(InterpreterDefaultContext var1, RDSeffSwitchContributionFactory.RDSeffElementDispatcher var2);
    }
}

