/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.EntityPackage;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.util.RepositorySwitch;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.ComposedRDSeffSwitchFactory;
import org.palladiosimulator.simulizar.interpreter.EventDispatcher;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.listener.AssemblyProvidedOperationPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EventType;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.runtimestate.ComponentInstanceRegistry;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.runtimestate.SimulatedBasicComponentInstanceFactory;
import org.palladiosimulator.simulizar.runtimestate.SimulatedCompositeComponentInstance;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;

public class RepositoryComponentSwitch
extends RepositorySwitch<InterpreterResult> {
    private static final Logger LOGGER = Logger.getLogger(RepositoryComponentSwitch.class);
    public static final AssemblyContext SYSTEM_ASSEMBLY_CONTEXT = CompositionFactory.eINSTANCE.createAssemblyContext();
    private final Signature signature;
    private final ProvidedRole providedRole;
    private final InterpreterDefaultContext context;
    private final AssemblyContext instanceAssemblyContext;
    private final IResourceTableManager resourceTableManager;
    private final ComposedRDSeffSwitchFactory rdseffSwitchFactory;
    private final Factory repositoryComponentSwitchFactory;
    private final ComponentInstanceRegistry componentRegistry;
    private final EventDispatcher eventHelper;
    private final SimulatedBasicComponentInstanceFactory simComponentFactory;

    @AssistedInject
    RepositoryComponentSwitch(@Assisted InterpreterDefaultContext context, @Assisted AssemblyContext assemblyContext, @Assisted Signature signature, @Assisted ProvidedRole providedRole, IResourceTableManager resourceTableManager, Factory repositoryComponentSwitchFactory, ComponentInstanceRegistry componentRegistry, ComposedRDSeffSwitchFactory rdseffSwitchFactory, EventDispatcher eventHelper, SimulatedBasicComponentInstanceFactory simComponentFactory) {
        this.context = context;
        this.instanceAssemblyContext = assemblyContext;
        this.signature = signature;
        this.providedRole = providedRole;
        this.resourceTableManager = resourceTableManager;
        this.componentRegistry = componentRegistry;
        this.rdseffSwitchFactory = rdseffSwitchFactory;
        this.repositoryComponentSwitchFactory = repositoryComponentSwitchFactory;
        this.eventHelper = eventHelper;
        this.simComponentFactory = simComponentFactory;
    }

    public InterpreterResult caseBasicComponent(BasicComponent basicComponent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entering BasicComponent: " + basicComponent));
        }
        SimulatedStack stack = this.context.getStack();
        SimulatedStackframe<Object> componentParameterStackFrame = SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)stack, (EList<VariableUsage>)basicComponent.getComponentParameterUsage_ImplementationComponentType(), (SimulatedStackframe<Object>)stack.currentStackFrame());
        SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)stack, (EList<VariableUsage>)this.instanceAssemblyContext.getConfigParameterUsages__AssemblyContext(), componentParameterStackFrame);
        FQComponentID fqID = this.context.computeFQComponentID();
        if (!this.componentRegistry.hasComponentInstance(fqID)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Found new basic component component instance, registering it: " + basicComponent));
                LOGGER.debug((Object)("FQComponentID is " + fqID));
            }
            this.componentRegistry.addComponentInstance(this.simComponentFactory.create(this.context, fqID, (List<PassiveResource>)basicComponent.getPassiveResource_BasicComponent()));
        }
        List<ServiceEffectSpecification> calledSeffs = this.getSeffsForCall((EList<ServiceEffectSpecification>)basicComponent.getServiceEffectSpecifications__BasicComponent(), this.signature);
        InterpreterResult result = this.interpretSeffs(calledSeffs, this.resourceTableManager);
        stack.removeStackFrame();
        stack.removeStackFrame();
        return result;
    }

    public InterpreterResult caseComposedProvidingRequiringEntity(ComposedProvidingRequiringEntity entity) {
        FQComponentID fqID;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entering ComposedProvidingRequiringEntity: " + entity));
        }
        if (!this.componentRegistry.hasComponentInstance(fqID = this.context.computeFQComponentID())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Found new composed component instance, registering it: " + entity));
                LOGGER.debug((Object)("FQComponentID is " + fqID));
            }
            this.componentRegistry.addComponentInstance(new SimulatedCompositeComponentInstance(fqID.getFQIDString()));
        }
        if (entity != this.providedRole.getProvidingEntity_ProvidedRole()) {
            throw new PCMModelInterpreterException("Interpret entity of provided role only");
        }
        ProvidedDelegationConnector connectedProvidedDelegationConnector = RepositoryComponentSwitch.getConnectedProvidedDelegationConnector(this.providedRole);
        RepositoryComponentSwitch repositoryComponentSwitch = this.repositoryComponentSwitchFactory.create(this.context, connectedProvidedDelegationConnector.getAssemblyContext_ProvidedDelegationConnector(), this.signature, (ProvidedRole)connectedProvidedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector());
        return Objects.requireNonNull((InterpreterResult)repositoryComponentSwitch.doSwitch((EObject)connectedProvidedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector()));
    }

    public InterpreterResult caseProvidedRole(ProvidedRole providedRole) {
        this.context.getAssemblyContextStack().push(this.instanceAssemblyContext == SYSTEM_ASSEMBLY_CONTEXT ? this.generateSystemAssemblyContext(providedRole) : this.instanceAssemblyContext);
        this.eventHelper.firePassedEvent(new AssemblyProvidedOperationPassedEvent<AssemblyContext, ProvidedRole, Signature>(providedRole, EventType.BEGIN, this.context, this.signature, this.instanceAssemblyContext));
        InterpreterResult result = (InterpreterResult)this.doSwitch((EObject)providedRole.getProvidingEntity_ProvidedRole());
        this.context.getAssemblyContextStack().pop();
        this.eventHelper.firePassedEvent(new AssemblyProvidedOperationPassedEvent<AssemblyContext, ProvidedRole, Signature>(providedRole, EventType.END, this.context, this.signature, this.instanceAssemblyContext));
        return result;
    }

    private AssemblyContext generateSystemAssemblyContext(ProvidedRole providedRole2) {
        AssemblyContext result = CompositionFactory.eINSTANCE.createAssemblyContext();
        result.setEntityName(this.providedRole.getProvidingEntity_ProvidedRole().getEntityName());
        result.setId(SYSTEM_ASSEMBLY_CONTEXT.getId());
        return result;
    }

    private List<ServiceEffectSpecification> getSeffsForCall(EList<ServiceEffectSpecification> serviceEffectSpecifications, Signature operationSignature) {
        assert (serviceEffectSpecifications != null && operationSignature != null);
        return serviceEffectSpecifications.stream().filter(seff -> seff.getDescribedService__SEFF().getId().equals(operationSignature.getId())).collect(Collectors.toList());
    }

    private InterpreterResult interpretSeffs(List<ServiceEffectSpecification> calledSeffs, IResourceTableManager resourceTableManager) {
        if (calledSeffs.size() != 1) {
            throw new PCMModelInterpreterException("Only exactly one SEFF is currently supported.");
        }
        if (!(calledSeffs.get(0) instanceof ResourceDemandingSEFF)) {
            throw new PCMModelInterpreterException("Only ResourceDemandingSEFFs are currently supported.");
        }
        Switch<InterpreterResult> interpreter = this.rdseffSwitchFactory.createRDSeffSwitch(this.context);
        return Objects.requireNonNull((InterpreterResult)interpreter.doSwitch((EObject)calledSeffs.get(0)));
    }

    private static ProvidedDelegationConnector getConnectedProvidedDelegationConnector(ProvidedRole providedRole) {
        InterfaceProvidingEntity implementingEntity = providedRole.getProvidingEntity_ProvidedRole();
        if (!CompositionPackage.eINSTANCE.getComposedStructure().isSuperTypeOf(implementingEntity.eClass())) {
            throw new PCMModelInterpreterException("Structure used for connector search must be a composed structure");
        }
        for (Connector connector : ((ComposedStructure)implementingEntity).getConnectors__ComposedStructure()) {
            if (connector.eClass() != CompositionPackage.eINSTANCE.getProvidedDelegationConnector() || !((ProvidedDelegationConnector)connector).getOuterProvidedRole_ProvidedDelegationConnector().equals(providedRole)) continue;
            return (ProvidedDelegationConnector)connector;
        }
        throw new PCMModelInterpreterException("Found unbound provided role. PCM model is invalid.");
    }

    protected InterpreterResult doSwitch(EClass theEClass, EObject theEObject) {
        if (EntityPackage.eINSTANCE.getComposedProvidingRequiringEntity().isSuperTypeOf(theEClass)) {
            return this.caseComposedProvidingRequiringEntity((ComposedProvidingRequiringEntity)theEObject);
        }
        return (InterpreterResult)super.doSwitch(theEClass, theEObject);
    }

    @AssistedFactory
    public static interface Factory {
        public RepositoryComponentSwitch create(InterpreterDefaultContext var1, AssemblyContext var2, Signature var3, ProvidedRole var4);
    }
}

