/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.simulizar.core.entity.EntityReferenceFactory;
import org.palladiosimulator.simulizar.core.entity.InterpretableLocationReference;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.EventDispatcher;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RepositoryComponentSwitch;
import org.palladiosimulator.simulizar.interpreter.listener.EventType;
import org.palladiosimulator.simulizar.interpreter.listener.InterpreterResultEventEmitter;
import org.palladiosimulator.simulizar.interpreter.listener.ModelElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.SystemOperationPassedEvent;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultHandler;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResumptionPolicy;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;
import org.palladiosimulator.simulizar.utils.TransitionDeterminer;

public class UsageScenarioSwitch
extends UsagemodelSwitch<InterpreterResult> {
    protected static final Logger LOGGER = Logger.getLogger((String)UsageScenarioSwitch.class.getName());
    private final InterpreterDefaultContext context;
    private final TransitionDeterminer transitionDeterminer;
    private final RepositoryComponentSwitch.Factory repositoryComponentSwitchFactory;
    private final EventDispatcher eventHelper;
    private final InterpreterResultMerger resultMerger;
    private final InterpreterResultHandler issueHandler;
    private final InterpreterResultEventEmitter resultEventEmitter;
    private final EntityReferenceFactory<UsageScenario> usageScenarioReferenceFactory;

    @AssistedInject
    UsageScenarioSwitch(@Assisted InterpreterDefaultContext context, RepositoryComponentSwitch.Factory repositoryComponentSwitchFactory, EntityReferenceFactory<UsageScenario> usageScenarioReferenceFactory, EventDispatcher eventHelper, InterpreterResultHandler issueHandler, InterpreterResultMerger resultMerger, InterpreterResultEventEmitter resultEventEmitter) {
        this.context = context;
        this.repositoryComponentSwitchFactory = repositoryComponentSwitchFactory;
        this.usageScenarioReferenceFactory = usageScenarioReferenceFactory;
        this.eventHelper = eventHelper;
        this.issueHandler = issueHandler;
        this.resultMerger = resultMerger;
        this.resultEventEmitter = resultEventEmitter;
        this.transitionDeterminer = new TransitionDeterminer(context);
    }

    public InterpreterResult caseScenarioBehaviour(ScenarioBehaviour object) {
        int stacksize = this.context.getStack().size();
        AbstractUserAction currentAction = null;
        for (AbstractUserAction abstractAction : object.getActions_ScenarioBehaviour()) {
            if (abstractAction.eClass() != UsagemodelPackage.Literals.START) continue;
            this.firePassedEvent(abstractAction, EventType.BEGIN);
            currentAction = abstractAction.getSuccessor();
            this.firePassedEvent(abstractAction, EventType.END);
            break;
        }
        if (currentAction == null) {
            throw new PCMModelInterpreterException("Usage Scenario is invalid, it misses a start action");
        }
        InterpreterResult result = InterpreterResult.OK;
        while (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE && currentAction.eClass() != UsagemodelPackage.Literals.STOP) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Interpret " + currentAction.eClass().getName() + ": " + currentAction));
            }
            this.firePassedEvent(currentAction, EventType.BEGIN);
            result = this.resultMerger.merge(result, (InterpreterResult)this.doSwitch((EObject)currentAction));
            this.firePassedEvent(currentAction, EventType.END);
            currentAction = currentAction.getSuccessor();
        }
        if (this.context.getStack().size() != stacksize) {
            throw new PCMModelInterpreterException("Interpreter did not pop all pushed stackframes");
        }
        return result;
    }

    public InterpreterResult caseBranch(Branch object) {
        BranchTransition branchTransition = this.transitionDeterminer.determineBranchTransition((EList<BranchTransition>)object.getBranchTransitions_Branch());
        return (InterpreterResult)this.doSwitch((EObject)branchTransition.getBranchedBehaviour_BranchTransition());
    }

    public InterpreterResult caseDelay(Delay object) {
        double delay = (Double)StackContext.evaluateStatic((String)object.getTimeSpecification_Delay().getSpecification(), Double.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Start delay " + delay + " @ simulation time " + this.context.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
        this.context.getThread().hold(delay);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Continue user @ simulation time " + this.context.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
        return InterpreterResult.OK;
    }

    public InterpreterResult caseEntryLevelSystemCall(EntryLevelSystemCall entryLevelSystemCall) {
        RepositoryComponentSwitch providedDelegationSwitch = this.repositoryComponentSwitchFactory.create(this.context, RepositoryComponentSwitch.SYSTEM_ASSEMBLY_CONTEXT, (Signature)entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall(), (ProvidedRole)entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall());
        this.eventHelper.firePassedEvent(new SystemOperationPassedEvent<System, OperationProvidedRole, OperationSignature>(entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall(), EventType.BEGIN, this.context, entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall(), (System)entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole()));
        SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)entryLevelSystemCall.getInputParameterUsages_EntryLevelSystemCall());
        this.context.getResultFrameStack().push((SimulatedStackframe<Object>)new SimulatedStackframe());
        InterpreterResult result = Objects.requireNonNull((InterpreterResult)providedDelegationSwitch.doSwitch((EObject)entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall()));
        this.context.getStack().removeStackFrame();
        SimulatedStackHelper.addParameterToStackFrame(this.context.getResultFrameStack().pop(), (EList<VariableUsage>)entryLevelSystemCall.getOutputParameterUsages_EntryLevelSystemCall(), (SimulatedStackframe<Object>)this.context.getStack().currentStackFrame());
        this.eventHelper.firePassedEvent(new SystemOperationPassedEvent<System, OperationProvidedRole, OperationSignature>(entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall(), EventType.END, this.context, entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall(), (System)entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole()));
        return result;
    }

    public InterpreterResult caseLoop(Loop object) {
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)object.getLoopIteration_Loop().getSpecification(), Integer.class);
        InterpreterResult result = InterpreterResult.OK;
        int i = 0;
        while (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE && i < numberOfLoops) {
            LOGGER.debug((Object)("Interpret loop number " + i));
            result = this.resultMerger.merge(result, (InterpreterResult)this.doSwitch((EObject)object.getBodyBehaviour_Loop()));
            LOGGER.debug((Object)("Finished loop number " + i));
            ++i;
        }
        return result;
    }

    public InterpreterResult caseAbstractUserAction(AbstractUserAction object) {
        throw new UnsupportedOperationException("An unsupported usage model element was encountered: " + object.eClass().getName());
    }

    public InterpreterResult caseUsageScenario(UsageScenario usageScenario) {
        this.eventHelper.firePassedEvent(new ModelElementPassedEvent<UsageScenario>(usageScenario, EventType.BEGIN, this.context));
        int stacksize = this.context.getStack().size();
        InterpreterResult result = (InterpreterResult)this.doSwitch((EObject)usageScenario.getScenarioBehaviour_UsageScenario());
        if (this.context.getStack().size() != stacksize) {
            throw new PCMModelInterpreterException("Interpreter did not pop all pushed stackframes");
        }
        if (!this.context.getResultFrameStack().isEmpty()) {
            throw new PCMModelInterpreterException("Interpreter missbehaving, not all result stack frames were properly removed.");
        }
        this.eventHelper.firePassedEvent(new ModelElementPassedEvent<UsageScenario>(usageScenario, EventType.END, this.context));
        this.resultEventEmitter.emitInterpretationFinished((InterpretableLocationReference)this.usageScenarioReferenceFactory.createCached((Entity)usageScenario), result, this.context);
        return result;
    }

    private <T extends AbstractUserAction> void firePassedEvent(T abstractAction, EventType eventType) {
        this.eventHelper.firePassedEvent(new ModelElementPassedEvent<T>(abstractAction, eventType, this.context));
    }

    @AssistedFactory
    public static interface Factory {
        public UsageScenarioSwitch create(InterpreterDefaultContext var1);
    }
}

