/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.Context;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.IAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.inject.Qualifier;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;

public class InterpreterDefaultContext
extends Context {
    private static final long serialVersionUID = -5027373777424401211L;
    private final Stack<AssemblyContext> assemblyContextStack = new Stack();
    private final Deque<SimulatedStackframe<Object>> resultFrameStack = new LinkedList<SimulatedStackframe<Object>>();
    private final PCMResourceSetPartition localPCMModelCopy;
    private final IAssemblyAllocationLookup<AbstractSimulatedResourceContainer> assemblyAllocationLookup;

    protected InterpreterDefaultContext(SimuComModel simuComModel, PCMResourceSetPartition localPartition, IAssemblyAllocationLookup<AbstractSimulatedResourceContainer> assemblyAllocationLookup, IResourceTableManager resourceTableManager, SimulatedStack<Object> stack) {
        super(simuComModel, resourceTableManager);
        this.stack = stack;
        this.localPCMModelCopy = localPartition;
        this.assemblyAllocationLookup = assemblyAllocationLookup;
    }

    public Stack<AssemblyContext> getAssemblyContextStack() {
        return this.assemblyContextStack;
    }

    @Deprecated
    public PCMResourceSetPartition getLocalPCMModelAtContextCreation() {
        return this.getLocalPCMModel();
    }

    public PCMResourceSetPartition getLocalPCMModel() {
        return this.localPCMModelCopy;
    }

    public IAssemblyAllocationLookup<AbstractSimulatedResourceContainer> getAssemblyAllocationLookup() {
        return this.assemblyAllocationLookup;
    }

    public FQComponentID computeFQComponentID() {
        return new FQComponentID(this.computeAssemblyContextPath());
    }

    private List<AssemblyContext> computeAssemblyContextPath() {
        Stack<AssemblyContext> stack = this.getAssemblyContextStack();
        ArrayList<AssemblyContext> result = new ArrayList<AssemblyContext>(stack.size() - 1);
        int i = 1;
        while (i < stack.size()) {
            result.add((AssemblyContext)stack.get(i));
            ++i;
        }
        return result;
    }

    public Deque<SimulatedStackframe<Object>> getResultFrameStack() {
        return this.resultFrameStack;
    }

    public SimulatedStackframe<Object> getCurrentResultFrame() {
        return this.resultFrameStack.peek();
    }

    public static InterpreterDefaultContext createChildContext(InterpreterDefaultContext parentContext, SimuComSimProcess simProcess) {
        SimulatedStack stackCopy = new SimulatedStack();
        if (parentContext.getStack().size() > 0) {
            stackCopy.pushStackFrame(parentContext.getStack().currentStackFrame().copyFrame());
        } else {
            stackCopy.pushStackFrame(new SimulatedStackframe());
        }
        InterpreterDefaultContext context = new InterpreterDefaultContext(parentContext.getModel(), parentContext.localPCMModelCopy, parentContext.assemblyAllocationLookup, parentContext.getResourceTableManager(), (SimulatedStack<Object>)stackCopy);
        context.assemblyContextStack.addAll(parentContext.getAssemblyContextStack());
        if (simProcess != null) {
            context.setSimProcess(simProcess);
        }
        context.setEvaluationMode(parentContext.getEvaluationMode());
        return context;
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MainContext {
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParentContext {
    }
}

