/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.impl;

import java.util.Objects;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.simulizar.core.entity.EntityReference;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.ComposedRDSeffSwitchFactory;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.InterpreterFacade;
import org.palladiosimulator.simulizar.interpreter.UsageScenarioSwitch;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;

public class EMFPackageBasedInterpreterFacade
implements InterpreterFacade {
    private final InterpreterDefaultContext context;
    private final PCMResourceSetPartition localPartition;
    private final UsageScenarioSwitch.Factory usageScenarioSwitchFactory;
    private final ComposedRDSeffSwitchFactory seffSwitchFactory;

    @Inject
    public EMFPackageBasedInterpreterFacade(InterpreterDefaultContext context, @PCMPartitionManager.Local PCMResourceSetPartition localPartition, UsageScenarioSwitch.Factory usageScenarioSwitchFactory, ComposedRDSeffSwitchFactory seffSwitchFactory) {
        this.context = context;
        this.localPartition = localPartition;
        this.usageScenarioSwitchFactory = usageScenarioSwitchFactory;
        this.seffSwitchFactory = seffSwitchFactory;
    }

    @Override
    public InterpreterResult submit(EntityReference<?> object) {
        return object.getModelElementIfPresent(this.localPartition).map(elem -> this.submit((EObject)elem)).orElse(InterpreterResult.OK);
    }

    @Override
    public InterpreterResult submit(EObject object) {
        String packageId;
        EObject entity = Objects.requireNonNull(object);
        switch (packageId = entity.eClass().getEPackage().getNsURI()) {
            case "http://palladiosimulator.org/PalladioComponentModel/UsageModel/5.2": {
                return (InterpreterResult)this.usageScenarioSwitchFactory.create(this.context).doSwitch(entity);
            }
            case "http://palladiosimulator.org/PalladioComponentModel/SEFF/5.2": {
                return (InterpreterResult)this.seffSwitchFactory.createRDSeffSwitch(this.context).doSwitch(entity);
            }
        }
        throw new UnsupportedOperationException("The current interpreter facade is incompatible with elements of the package " + packageId);
    }
}

