/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.listener;

import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.measurementframework.listener.MeasurementSource;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.recorderframework.core.IRecorder;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.core.utils.RecorderExtensionHelper;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractProbeFrameworkListener;

public abstract class AbstractRecordingProbeFrameworkListenerDecorator {
    private AbstractProbeFrameworkListener probeFrameworkListener;

    public void setProbeFrameworkListener(AbstractProbeFrameworkListener probeFrameworkListener) {
        this.probeFrameworkListener = probeFrameworkListener;
    }

    public void registerMeasurements() {
        if (this.probeFrameworkListener == null) {
            throw new IllegalStateException("No ProbeFrameworkListener at hand. Ensure that setProbeFrameworkListener(..) has been called beforehand.");
        }
    }

    protected AbstractProbeFrameworkListener getProbeFrameworkListener() {
        return this.probeFrameworkListener;
    }

    protected ProbeFrameworkContext getProbeFrameworkContext() {
        return this.probeFrameworkListener.simuComModel.getProbeFrameworkContext();
    }

    protected IRecorder initializeRecorder(Map<String, Object> recorderConfigMap) {
        assert (recorderConfigMap != null);
        SimuComConfig config = this.probeFrameworkListener.getSimuComModel().getConfiguration();
        IRecorder recorder = this.instantiateRecorder(config);
        recorder.initialize(this.createRecorderConfiguration(config, recorderConfigMap));
        return recorder;
    }

    protected IRecorder instantiateRecorder(SimuComConfig config) {
        assert (config != null);
        return RecorderExtensionHelper.instantiateRecorderImplementationForRecorder((String)config.getRecorderName());
    }

    protected IRecorderConfiguration createRecorderConfiguration(SimuComConfig config, Map<String, Object> recorderConfigMap) {
        assert (recorderConfigMap != null && config != null);
        return config.getRecorderConfigurationFactory().createRecorderConfiguration(recorderConfigMap);
    }

    protected void registerMeasurementsRecorder(MeasurementSource measurementSource, IRecorder recorder) {
        assert (measurementSource != null && recorder != null);
        measurementSource.addObserver((IMeasurementSourceListener)recorder);
    }

    public static Map<String, Object> createRecorderConfigMapWithAcceptedMetricAndMeasuringPoint(MetricDescription recorderAcceptedMetric, MeasuringPoint measuringPoint) {
        assert (recorderAcceptedMetric != null);
        assert (measuringPoint != null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("recorderAcceptedMetric", recorderAcceptedMetric);
        result.put("measuringPoint", measuringPoint);
        return result;
    }
}

