/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.ICompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.core.jobs.LoadModelIntoBlackboardJob;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.launcher.jobs.ModelContribution;

public class LoadSimuLizarModelsIntoBlackboardJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements ModelContribution.Facade {
    public static final String PCM_MODELS_ANALYZED_PARTITION_ID = "org.palladiosimulator.analyzed.partition";

    @Inject
    public LoadSimuLizarModelsIntoBlackboardJob(SimuLizarWorkflowConfiguration configuration, Provider<Set<ModelContribution>> modelContributionExtensions) {
        super(false);
        this.addStandardJobs(configuration);
        this.addExtensionJobs(modelContributionExtensions);
    }

    protected void addStandardJobs(SimuLizarWorkflowConfiguration configuration) {
        this.addLoadPCMModelJobs(configuration);
        this.addLoadMonitorRepository(configuration);
        this.addSLORepository(configuration);
        this.addUsageEvolution(configuration);
    }

    protected void addExtensionJobs(Provider<Set<ModelContribution>> modelContributionExtensions) {
        ((Set)modelContributionExtensions.get()).forEach(contrib -> contrib.loadModel(this));
    }

    protected void addLoadPCMModelJobs(SimuLizarWorkflowConfiguration configuration) {
        configuration.getPCMModelFiles().forEach(m -> LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob((String)m, (ICompositeJob)this));
    }

    protected void addLoadMonitorRepository(SimuLizarWorkflowConfiguration configuration) {
        LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob((String)configuration.getMonitorRepositoryFile(), (ICompositeJob)this);
    }

    protected void addSLORepository(SimuLizarWorkflowConfiguration configuration) {
        LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob((String)configuration.getServiceLevelObjectivesFile(), (ICompositeJob)this);
    }

    protected void addUsageEvolution(SimuLizarWorkflowConfiguration configuration) {
        LoadModelIntoBlackboardJob.parseUriAndAddModelLoadJob((String)configuration.getUsageEvolutionFile(), (ICompositeJob)this);
    }

    @Override
    public void loadModel(URI modelURI) {
        this.loadModel(modelURI, "org.palladiosimulator.pcmmodels.partition");
    }

    @Override
    public void loadModel(URI modelURI, String partitionId) {
        this.addJob((IJob)new LoadModelIntoBlackboardJob(modelURI, partitionId));
    }
}

