/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.metrics;

import java.util.Objects;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurement;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementFactory;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;

public abstract class PRMRecorder {
    private final RuntimeMeasurement measurement;
    private final RuntimeMeasurementModel prmAccess;

    public PRMRecorder(RuntimeMeasurementModel prmAccess, MeasurementSpecification measurementSpecification, MeasuringPoint measuringPoint) {
        if (!measurementSpecification.isTriggersSelfAdaptations()) {
            throw new RuntimeException("PRM recordering only allowed when self-adaptations shall be triggered");
        }
        this.measurement = RuntimeMeasurementFactory.eINSTANCE.createRuntimeMeasurement();
        this.measurement.setMeasuringPoint(measuringPoint);
        this.measurement.setMeasurementSpecification(measurementSpecification);
        this.prmAccess = prmAccess;
        this.attachToPRM();
    }

    public PRMRecorder(RuntimeMeasurementModel prmAccess, MeasurementSpecification measurementSpecification) {
        this(Objects.requireNonNull(prmAccess), Objects.requireNonNull(measurementSpecification), measurementSpecification.getMonitor().getMeasuringPoint());
    }

    private void attachToPRM() {
        if (!this.prmAccess.getMeasurements().contains((Object)this.measurement)) {
            this.prmAccess.getMeasurements().add((Object)this.measurement);
        }
    }

    protected final void detachFromPRM() {
        this.prmAccess.getMeasurements().remove((Object)this.measurement);
    }

    protected void updateMeasurementValue(double value) {
        this.measurement.setMeasuringValue(value);
    }

    protected MeasurementSpecification getMeasurementSpecification() {
        return this.measurement.getMeasurementSpecification();
    }

    protected final RuntimeMeasurement getPRMMeasurement() {
        return this.measurement;
    }

    protected RuntimeMeasurementModel getPrmModel() {
        return this.prmAccess;
    }
}

