/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration;

import de.uka.ipd.sdq.simucomframework.core.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeNumberOfResourceContainersProbe;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.TriggeredProbeList;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.listener.EventResult;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public class NumberOfResourceContainerTrackingListener
implements IReconfigurationListener {
    private static final Logger LOGGER = Logger.getLogger(NumberOfResourceContainerTrackingListener.class);
    private final ISimulationControl simulationControl;
    private final PCMResourceSetPartition pcmPartition;
    private final IGenericCalculatorFactory calculatorFactory;
    int previousNumberOfContainers = 0;
    Optional<TriggeredProbe> numberOfResourceContainerProbe = Optional.empty();

    @Inject
    public NumberOfResourceContainerTrackingListener(ISimulationControl simulationControl, @PCMPartitionManager.Global PCMResourceSetPartition pcmPartition, IGenericCalculatorFactory calculatorFactory) {
        this.simulationControl = simulationControl;
        this.pcmPartition = pcmPartition;
        this.calculatorFactory = calculatorFactory;
    }

    @Override
    public void initialize() {
        this.previousNumberOfContainers = this.getNumberOfResourceContainers();
        this.numberOfResourceContainerProbe = this.initNumberOfResourceContainersCalculator();
    }

    @Override
    public void reconfigurationExecuted(ReconfigurationExecutedEvent reconfExecutedEvent) {
        if (this.numberOfResourceContainerProbe.isEmpty()) {
            return;
        }
        if (reconfExecutedEvent.getReconfigurationResult() == EventResult.SUCCESS) {
            LOGGER.debug((Object)("Successful system reconfiguration lasted " + reconfExecutedEvent.getDuration() + " time units"));
            LOGGER.debug((Object)"Collected notifications:");
            reconfExecutedEvent.getModelChanges().forEach(notification -> LOGGER.debug((Object)(" " + notification.getNotifier())));
            int noRC = this.getNumberOfResourceContainers();
            if (this.previousNumberOfContainers != noRC) {
                this.previousNumberOfContainers = noRC;
                this.numberOfResourceContainerProbe.get().takeMeasurement();
            }
        }
    }

    private Optional<TriggeredProbe> initNumberOfResourceContainersCalculator() {
        Optional repo = this.pcmPartition.getElement(MonitorRepositoryPackage.eINSTANCE.getMonitorRepository()).stream().findAny();
        if (repo.isPresent()) {
            MonitorRepository monitorRepository = (MonitorRepository)repo.get();
            ResourceEnvironment resourceEnvironment = this.pcmPartition.getAllocation().getTargetResourceEnvironment_Allocation();
            for (MeasurementSpecification measurementSpecification : MonitorRepositoryUtil.getMeasurementSpecificationsForElement(monitorRepository, (EObject)resourceEnvironment)) {
                if (!MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)measurementSpecification.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS)) continue;
                MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
                TriggeredProbeList numberOfResourceCalculatorsProbes = new TriggeredProbeList((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, Arrays.asList(new TakeNumberOfResourceContainersProbe(resourceEnvironment), new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)this.simulationControl)));
                this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)numberOfResourceCalculatorsProbes));
                numberOfResourceCalculatorsProbes.takeMeasurement();
                return Optional.of(numberOfResourceCalculatorsProbes);
            }
        }
        return Optional.empty();
    }

    private int getNumberOfResourceContainers() {
        return this.pcmPartition.getAllocation().getTargetResourceEnvironment_Allocation().getResourceContainer_ResourceEnvironment().size();
    }
}

