/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.core.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.core.usage.IWorkloadDriver;
import de.uka.ipd.sdq.simucomframework.usage.ClosedWorkloadUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.ICancellableWorkloadDriver;
import de.uka.ipd.sdq.simucomframework.usage.IClosedWorkloadUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.OpenWorkload;
import de.uka.ipd.sdq.simucomframework.usage.OpenWorkloadUserFactory;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.Workload;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.simulizar.core.entity.EntityReference;
import org.palladiosimulator.simulizar.core.entity.EntityReferenceFactory;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.usagemodel.IScenarioRunnerFactory;

public class SimulatedUsageModels {
    private static final Logger LOGGER = Logger.getLogger(SimulatedUsageModels.class);
    private final Map<ClosedWorkload, de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload> closedWorkloads = new HashMap<ClosedWorkload, de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload>();
    private final Map<org.palladiosimulator.pcm.usagemodel.OpenWorkload, OpenWorkload> openWorkloads = new HashMap<org.palladiosimulator.pcm.usagemodel.OpenWorkload, OpenWorkload>();
    private final IResourceTableManager resourceTableManager;
    private final SimuComModel simucomModel;
    private final EntityReferenceFactory<UsageScenario> usageScenarioReferenceFactory;
    private final IScenarioRunnerFactory<Entity> scenarioRunnerFactory;

    @Inject
    public SimulatedUsageModels(@InterpreterDefaultContext.MainContext Provider<InterpreterDefaultContext> rootContextProvider, @PCMPartitionManager.Global PCMResourceSetPartition globalPartition, SimuComModel simucomModel, IResourceTableManager resourceTableManager, EntityReferenceFactory<UsageScenario> usageScenarioReferenceFactory, IScenarioRunnerFactory<Entity> scenarioRunnerFactory) {
        this.simucomModel = simucomModel;
        this.resourceTableManager = resourceTableManager;
        this.usageScenarioReferenceFactory = usageScenarioReferenceFactory;
        this.scenarioRunnerFactory = scenarioRunnerFactory;
    }

    public IWorkloadDriver createAndAddWorkloadDriver(UsageScenario usageScenario) {
        Workload workload = usageScenario.getWorkload_UsageScenario();
        if (workload.eClass() == UsagemodelPackage.eINSTANCE.getClosedWorkload()) {
            de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload driver = this.createClosedWorkloadDriver(workload, usageScenario);
            this.closedWorkloads.put((ClosedWorkload)workload, driver);
            this.simucomModel.getUsageScenarios().add(driver);
            return driver;
        }
        if (workload.eClass() == UsagemodelPackage.eINSTANCE.getOpenWorkload()) {
            OpenWorkload driver = this.createOpenWorkloadDriver(workload, usageScenario);
            this.openWorkloads.put((org.palladiosimulator.pcm.usagemodel.OpenWorkload)workload, driver);
            this.simucomModel.getUsageScenarios().add(driver);
            return driver;
        }
        throw new UnsupportedOperationException("Unsupported Workload Found");
    }

    public void cancelAndUnregisterWorkloadDriver(Workload workload) {
        ICancellableWorkloadDriver workloadDriver = (ICancellableWorkloadDriver)new UsagemodelSwitch<ICancellableWorkloadDriver>(){

            public ICancellableWorkloadDriver caseOpenWorkload(org.palladiosimulator.pcm.usagemodel.OpenWorkload object) {
                return (ICancellableWorkloadDriver)SimulatedUsageModels.this.openWorkloads.remove(object);
            }

            public ICancellableWorkloadDriver caseClosedWorkload(ClosedWorkload object) {
                return (ICancellableWorkloadDriver)SimulatedUsageModels.this.closedWorkloads.remove(object);
            }
        }.doSwitch((EObject)workload);
        if (workloadDriver != null) {
            workloadDriver.cancel();
            this.simucomModel.getUsageScenarios().remove(workloadDriver);
        }
    }

    private de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload createClosedWorkloadDriver(Workload workload, final UsageScenario usageScenario) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Create workload driver for ClosedWorkload: " + workload));
        }
        ClosedWorkload closedWorkload = (ClosedWorkload)workload;
        ClosedWorkloadUserFactory userFactory = new ClosedWorkloadUserFactory(this.simucomModel, closedWorkload.getThinkTime_ClosedWorkload().getSpecification(), usageScenario, this.resourceTableManager){

            public IScenarioRunner createScenarioRunner() {
                return SimulatedUsageModels.this.scenarioRunnerFactory.createScenarioRunner((EntityReference<Entity>)SimulatedUsageModels.this.usageScenarioReferenceFactory.createCached((Entity)usageScenario));
            }
        };
        return new de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload((IClosedWorkloadUserFactory)userFactory, closedWorkload.getPopulation());
    }

    private OpenWorkload createOpenWorkloadDriver(Workload workload, final UsageScenario usageScenario) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Create workload driver for OpenWorkload: " + workload));
        }
        org.palladiosimulator.pcm.usagemodel.OpenWorkload openWorkload = (org.palladiosimulator.pcm.usagemodel.OpenWorkload)workload;
        OpenWorkloadUserFactory userFactory = new OpenWorkloadUserFactory(this.simucomModel, usageScenario, this.resourceTableManager){

            public IScenarioRunner createScenarioRunner() {
                return SimulatedUsageModels.this.scenarioRunnerFactory.createScenarioRunner((EntityReference<Entity>)SimulatedUsageModels.this.usageScenarioReferenceFactory.createCached((Entity)usageScenario));
            }
        };
        return new OpenWorkload(this.simucomModel, (IUserFactory)userFactory, openWorkload.getInterArrivalTime_OpenWorkload().getSpecification(), this.resourceTableManager);
    }

    public ICancellableWorkloadDriver getWorkloadDriver(Workload workload) {
        return (ICancellableWorkloadDriver)new UsagemodelSwitch<ICancellableWorkloadDriver>(){

            public ICancellableWorkloadDriver caseClosedWorkload(ClosedWorkload object) {
                return SimulatedUsageModels.this.getClosedWorkloadDriver(object);
            }

            public ICancellableWorkloadDriver caseOpenWorkload(org.palladiosimulator.pcm.usagemodel.OpenWorkload object) {
                return SimulatedUsageModels.this.getOpenWorkloadDriver(object);
            }
        }.doSwitch((EObject)workload);
    }

    public OpenWorkload getOpenWorkloadDriver(org.palladiosimulator.pcm.usagemodel.OpenWorkload openWorkload) {
        return this.openWorkloads.get(openWorkload);
    }

    public de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload getClosedWorkloadDriver(ClosedWorkload closedWorkload) {
        return this.closedWorkloads.get(closedWorkload);
    }
}

