/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utils;

import de.uka.ipd.sdq.simulation.abstractsimengine.SimCondition;
import de.uka.ipd.sdq.statistics.IBatchAlgorithm;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import de.uka.ipd.sdq.statistics.estimation.IConfidenceEstimator;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class MultipleRunsConfidenceStopCondition
implements SimCondition,
IMeasurementSourceListener {
    private static final Logger LOGGER = Logger.getLogger(MultipleRunsConfidenceStopCondition.class);
    private ConfidenceInterval confidence;
    private boolean confidenceReached = false;
    private final IBatchAlgorithm batchAlgorithm;
    private final IConfidenceEstimator estimator;
    private final double confidenceLevel;
    private final double halfWidth;
    private int minBatches;

    public MultipleRunsConfidenceStopCondition(IBatchAlgorithm batchAlgorithm, IConfidenceEstimator estimator, double confidenceLevel, double halfWidth) {
        this.batchAlgorithm = batchAlgorithm;
        this.estimator = estimator;
        this.confidenceLevel = confidenceLevel;
        this.halfWidth = halfWidth;
        this.minBatches = 0;
    }

    public boolean check() {
        return this.confidenceReached;
    }

    public void newMeasurementAvailable(MeasuringValue resultTuple) {
        ConfidenceInterval ci;
        Measure reconfigurationTimeMeasure = resultTuple.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.RECONFIGURATION_TIME_METRIC);
        double reconfigurationTime = reconfigurationTimeMeasure.doubleValue((Unit)SI.SECOND);
        this.batchAlgorithm.offerSample(reconfigurationTime);
        if (this.batchAlgorithm.hasValidBatches() && this.batchAlgorithm.getBatchMeans().size() >= this.minBatches && (ci = this.estimator.estimateConfidence(this.batchAlgorithm.getBatchMeans(), this.confidenceLevel)) != null) {
            ConfidenceInterval targetCI = new ConfidenceInterval(ci.getMean(), this.halfWidth, this.confidenceLevel);
            if (targetCI.contains(ci)) {
                if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                    LOGGER.info((Object)"Requested confidence reached.");
                }
                this.confidenceReached = true;
                this.confidence = ci;
                this.minBatches = this.batchAlgorithm.getBatchMeans().size() + 1;
            } else {
                if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                    LOGGER.info((Object)"Requested confidence not yet reached.");
                }
                this.minBatches = this.batchAlgorithm.getBatchMeans().size() + 1;
            }
            if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.info((Object)("Current confidence interval: Mean " + ci.getMean() + ", " + this.confidenceLevel * 100.0 + "% Confidence Interval " + "[" + ci.getLowerBound() + "," + ci.getUpperBound() + "]"));
            }
        }
    }

    public ConfidenceInterval getConfidence() {
        return this.confidence;
    }

    public void preUnregister() {
    }
}

