/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utils;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.runtimemeasurement.util.RuntimeMeasurementResourceFactoryImpl;

public class ResourceUtil {
    private static final Logger LOGGER = Logger.getLogger((String)ResourceUtil.class.getName());
    private static final String RM_MODEL_FILE_EXTENSION = ".runtimemeasurement";
    private static final String DEFAULT_FILE_NAME = "tmp";

    public static Resource createRuntimeMeasurementModelResource(String storingLocation) {
        return ResourceUtil.createResourceOf(RM_MODEL_FILE_EXTENSION, (ResourceFactoryImpl)new RuntimeMeasurementResourceFactoryImpl(), storingLocation);
    }

    public static Resource createResourceOf(String fileExt, ResourceFactoryImpl resourceFactory, String storingLocation) {
        ResourceSetImpl rsHelper = new ResourceSetImpl();
        rsHelper.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExt, resourceFactory);
        if (ResourceUtil.isNotValid(storingLocation)) {
            return rsHelper.createResource(ResourceUtil.defaultFileURI());
        }
        URI rmModelUri = URI.createURI((String)ResourceUtil.construct(fileExt, storingLocation));
        if (!rmModelUri.isPlatformResource() || storingLocation.isEmpty()) {
            rmModelUri = ResourceUtil.defaultFileURI();
        }
        return rsHelper.createResource(rmModelUri);
    }

    private static boolean isNotValid(String storingLocation) {
        return storingLocation == null || storingLocation.isEmpty();
    }

    private static String construct(String fileExt, String storingLocation) {
        storingLocation = ResourceUtil.removeLastSegment(storingLocation);
        return String.format("%1s%2s.%3s", storingLocation, DEFAULT_FILE_NAME, fileExt);
    }

    private static String removeLastSegment(String storingLocation) {
        String last = URI.createFileURI((String)storingLocation).lastSegment();
        return storingLocation.replace(last, "");
    }

    private static URI defaultFileURI() {
        File tmp = null;
        try {
            tmp = File.createTempFile(DEFAULT_FILE_NAME, RM_MODEL_FILE_EXTENSION);
        }
        catch (IOException ex) {
            LOGGER.info((Object)String.format("The temporary file for the runtime measurement model could not be created: %s", ex.getMessage()));
        }
        return URI.createFileURI((String)tmp.getAbsolutePath());
    }
}

